/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jgrasstools.gears.io.dxfdwg.libs.DwgReader;
import org.jgrasstools.gears.io.dxfdwg.libs.GeometryTranslator;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgFile;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DwgHandler {
    private final DwgFile dwgFile;
    private GeometryTranslator gTranslator;

    public DwgHandler(File dxfFile, CoordinateReferenceSystem crs) {
        this.dwgFile = new DwgFile(dxfFile.getAbsolutePath());
        this.gTranslator = new GeometryTranslator(crs);
    }

    public DwgReader getDwgReader() throws Exception {
        DwgReader dwgReader = new DwgReader(this.dwgFile, this.gTranslator);
        return dwgReader;
    }

    public List<String> getLayerTypes() throws Exception {
        this.dwgFile.read();
        this.dwgFile.initializeLayerTable();
        this.dwgFile.calculateGisModelDwgPolylines();
        this.dwgFile.applyExtrusions();
        this.dwgFile.testDwg3D();
        this.dwgFile.blockManagement();
        Vector<String> layerNames = this.dwgFile.getLayerNames();
        if (layerNames.size() < 1) {
            throw new IOException("No layer found in the file.");
        }
        return layerNames;
    }
}

