/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sourceforge.jeuclid.converter.BatikConverter;
import net.sourceforge.jeuclid.converter.ConverterDetector;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.elements.generic.JEuclidDOMImplementation;
import net.sourceforge.jeuclid.elements.support.ClassLoaderSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;

public final class BatikDetector
implements ConverterDetector {
    private static final Log LOGGER = LogFactory.getLog(BatikDetector.class);

    private static DOMImplementation findSVGDOMImplementation() {
        DOMImplementation dOMImplementation;
        try {
            Class<?> clazz = ClassLoaderSupport.getInstance().loadClass("org.apache.batik.dom.svg.SVGDOMImplementation");
            Method method = clazz.getMethod("getDOMImplementation", new Class[0]);
            dOMImplementation = (DOMImplementation)method.invoke(null, (Object[])null);
        }
        catch (RuntimeException runtimeException) {
            dOMImplementation = null;
        }
        catch (LinkageError linkageError) {
            dOMImplementation = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            dOMImplementation = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            dOMImplementation = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            dOMImplementation = null;
        }
        catch (InvocationTargetException invocationTargetException) {
            dOMImplementation = null;
        }
        if (dOMImplementation == null) {
            dOMImplementation = JEuclidDOMImplementation.getInstance();
        }
        return dOMImplementation;
    }

    public void detectConversionPlugins(ConverterRegistry converterRegistry) {
        try {
            ClassLoaderSupport.getInstance().loadClass("org.apache.batik.svggen.SVGGraphics2D");
            LOGGER.debug((Object)"Batik detected!");
            converterRegistry.registerMimeTypeAndSuffix("image/svg+xml", "svg", true);
            DOMImplementation dOMImplementation = BatikDetector.findSVGDOMImplementation();
            if (dOMImplementation != null) {
                converterRegistry.registerConverter("image/svg+xml", new BatikConverter(dOMImplementation), true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug((Object)"Batik is not in classpath!");
        }
    }
}

