/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BatikConverter
implements ConverterPlugin {
    private static final Log LOGGER = LogFactory.getLog(BatikConverter.class);
    private final DOMImplementation domImplementation;

    BatikConverter(DOMImplementation dOMImplementation) {
        this.domImplementation = dOMImplementation;
    }

    public Dimension convert(Node node, LayoutContext layoutContext, OutputStream outputStream) throws IOException {
        ConverterPlugin.DocumentWithDimension documentWithDimension = this.convert(node, layoutContext);
        if (documentWithDimension != null) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource dOMSource = new DOMSource(documentWithDimension.getDocument());
                StreamResult streamResult = new StreamResult(outputStream);
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                LOGGER.warn((Object)transformerException);
            }
            return documentWithDimension.getDimension();
        }
        return null;
    }

    public ConverterPlugin.DocumentWithDimension convert(Node node, LayoutContext layoutContext) {
        Document document = null;
        document = this.domImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        if (document != null) {
            SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
            sVGGeneratorContext.setComment("Converted from MathML using JEuclid");
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, true);
            JEuclidView jEuclidView = new JEuclidView(node, layoutContext, (Graphics2D)sVGGraphics2D);
            int n = (int)Math.ceil(jEuclidView.getAscentHeight());
            int n2 = (int)Math.ceil(jEuclidView.getDescentHeight());
            int n3 = n + n2;
            int n4 = (int)Math.ceil(jEuclidView.getWidth());
            Dimension dimension = new Dimension(n4, n3);
            sVGGraphics2D.setSVGCanvasSize(dimension);
            jEuclidView.draw((Graphics2D)sVGGraphics2D, 0.0f, n);
            document.replaceChild(sVGGraphics2D.getRoot(), document.getFirstChild());
            return new ConverterPlugin.DocumentWithDimension(document, new Dimension(n4, n3), n2);
        }
        return null;
    }
}

