/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.workspace.plugins.waterml2.Common;
import jams.workspace.plugins.waterml2.TimeValuePair;
import jams.workspace.plugins.waterml2.WaterML2Exception;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Timeserie {
    private ArrayList<TimeValuePair> result = new ArrayList();
    private GregorianCalendar startAnchorPoint = null;
    private GregorianCalendar endAnchorPoint = null;
    private GregorianCalendar baseTime = null;
    private long spacing = 0L;
    private TimeValuePair defaultTimeValuePair = null;
    private GregorianCalendar currentTime = null;

    public Timeserie(Node timeserieNode) throws WaterML2Exception {
        NodeList list = timeserieNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeName().matches(".*domainExtent")) continue;
            if (node.getNodeName().matches(".*startAnchorPoint")) {
                try {
                    this.startAnchorPoint = new GregorianCalendar();
                    this.startAnchorPoint.setTime(Common.WML2_TIME_FORMAT.parse(node.getNodeValue()));
                    continue;
                }
                catch (ParseException pe) {
                    throw new WaterML2Exception("invalid date: " + node.getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*endAnchorPoint")) {
                try {
                    this.endAnchorPoint = new GregorianCalendar();
                    this.endAnchorPoint.setTime(Common.WML2_TIME_FORMAT.parse(node.getNodeValue()));
                    continue;
                }
                catch (ParseException pe) {
                    throw new WaterML2Exception("invalid date: " + node.getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*baseTime")) {
                try {
                    this.baseTime = new GregorianCalendar();
                    this.baseTime.setTime(Common.WML2_TIME_FORMAT.parse(node.getNodeValue()));
                    this.currentTime = (GregorianCalendar)this.baseTime.clone();
                    continue;
                }
                catch (ParseException pe) {
                    throw new WaterML2Exception("invalid date: " + node.getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*spacing")) {
                try {
                    this.spacing = Long.parseLong(node.getNodeValue());
                    continue;
                }
                catch (NumberFormatException pe) {
                    throw new WaterML2Exception("invalid spacing: " + node.getNodeValue());
                }
            }
            if (node.getNodeName().matches(".*cumulative") || node.getNodeName().matches(".*accumulationAnchorTime") || node.getNodeName().matches(".*accumulationIntervalLength") || node.getNodeName().matches(".*aggregationDatum") || node.getNodeName().matches(".*commentBlock") || node.getNodeName().matches(".*parameter")) continue;
            if (node.getNodeName().matches(".*defaultTimeValuePair")) {
                this.defaultTimeValuePair = new TimeValuePair(node, null);
                if (this.defaultTimeValuePair.unit != null) continue;
                this.defaultTimeValuePair.unit = "";
                continue;
            }
            if (!node.getNodeName().matches(".*point")) continue;
            this.result.add(this.readPoint(node));
        }
    }

    private TimeValuePair readPoint(Node pointNode) throws WaterML2Exception {
        NodeList list = pointNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().matches(".*TimeValuePair")) continue;
            TimeValuePair tvp = new TimeValuePair(node, this.defaultTimeValuePair);
            if (this.currentTime != null) {
                this.currentTime.add(13, (int)this.spacing);
                if (this.defaultTimeValuePair == null) {
                    this.defaultTimeValuePair = new TimeValuePair();
                }
                this.defaultTimeValuePair.time = this.currentTime;
            }
            return tvp;
        }
        return null;
    }

    public TimeValuePair[] getData() {
        TimeValuePair[] tvp = new TimeValuePair[this.result.size()];
        int counter = 0;
        for (TimeValuePair t : this.result) {
            tvp[counter++] = t;
        }
        return tvp;
    }
}

