/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins.waterml2;

import jams.workspace.plugins.waterml2.Metadata;
import jams.workspace.plugins.waterml2.ObservationMember;
import jams.workspace.plugins.waterml2.WaterML2Exception;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureCollection {
    Metadata metadata = null;
    ArrayList<ObservationMember> observations = new ArrayList();

    public FeatureCollection(Node featureCollectionNode) throws WaterML2Exception {
        NodeList nodeList = featureCollectionNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().matches(".*metaDataProperty") || node.getNodeName().matches(".*description") || node.getNodeName().matches(".*descriptionReference") || node.getNodeName().matches(".*identifier") || node.getNodeName().matches(".*name") || node.getNodeName().matches(".*boundedBy") || node.getNodeName().matches(".*location")) continue;
            if (node.getNodeName().matches(".*metadata")) {
                if (this.hasDocumentMetadata()) {
                    throw new WaterML2Exception.DuplicateEntryException(node.getNodeName());
                }
                this.setMetadata(new Metadata(node));
                continue;
            }
            if (node.getNodeName().matches(".*temporalExtent") || node.getNodeName().matches(".*parameter") || node.getNodeName().matches(".*phenomenalDirectory") || node.getNodeName().matches(".*qualifierDirectory") || node.getNodeName().matches(".*processingDirectory") || node.getNodeName().matches(".*samplingFeatureMember")) continue;
            if (node.getNodeName().matches(".*observationMember")) {
                this.addObservationMember(new ObservationMember(node));
                continue;
            }
            if (!node.getNodeName().matches(".*extension")) continue;
        }
    }

    private void setMetadata(Metadata docMetadata) {
        this.metadata = docMetadata;
    }

    private boolean hasDocumentMetadata() {
        return this.metadata != null;
    }

    private void addObservationMember(ObservationMember observation) {
        this.observations.add(observation);
    }
}

