/*
 * Decompiled with CFR 0.152.
 */
package jams.components.unit;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;

public class RainfallIntensityToDepth
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="rainfall intensity in [kg/(m\u00b2s)]")
    public Attribute.Double intensity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="output in [mm] per time unit")
    public Attribute.Double millimeter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval to provide unit")
    public Attribute.TimeInterval timeUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval to provide unit")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="density in [kg / m\u00b3] (default = 1000.0 for water)", defaultValue="1000.0")
    public Attribute.Double density;

    public void run() {
        double secondsInTimeUnit = 0.0;
        switch (this.timeUnit.getTimeUnit()) {
            case 11: {
                secondsInTimeUnit = 3600.0;
                break;
            }
            case 6: {
                secondsInTimeUnit = 86400.0;
                break;
            }
            case 2: {
                secondsInTimeUnit = 86400 * this.time.getValue().getActualMaximum(5);
                break;
            }
            case 1: {
                secondsInTimeUnit = 86400 * this.time.getValue().getActualMaximum(6);
            }
        }
        this.millimeter.setValue(this.intensity.getValue() / this.density.getValue() * 1000.0 * secondsInTimeUnit);
    }
}

