/*
 * Decompiled with CFR 0.152.
 */
package jams.components.regionalization;

public class IDW {
    public static double[] calcDistances(double entityX, double entityY, double[] statX, double[] statY, double pidw) {
        double[] dist = new double[statX.length];
        for (int s = 0; s < statX.length; ++s) {
            double x = entityX - statX[s];
            double y = entityY - statY[s];
            dist[s] = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
            dist[s] = Math.abs(Math.pow(dist[s], pidw));
        }
        return dist;
    }

    public static double[] equalWeights(int nStat) {
        double[] weights = new double[nStat];
        for (int i = 0; i < nStat; ++i) {
            weights[i] = 1.0 / (double)nStat;
        }
        return weights;
    }

    public static double[] calcWeights(double[] dist) {
        int i;
        int nstat = dist.length;
        double[] weight = new double[nstat];
        double[] temp = new double[nstat];
        double distsum = 0.0;
        double tempsum = 0.0;
        for (i = 0; i < nstat; ++i) {
            distsum += dist[i];
        }
        for (i = 0; i < nstat; ++i) {
            temp[i] = distsum / dist[i];
            tempsum += temp[i];
        }
        for (int s = 0; s < nstat; ++s) {
            if (dist[s] == 0.0) {
                for (int j = 0; j < nstat; ++j) {
                    weight[j] = 0.0;
                }
                weight[s] = 1.0;
                return weight;
            }
            weight[s] = temp[s] / tempsum;
        }
        return weight;
    }

    public static double[] calcNidwWeights(double entityX, double entityY, double[] statX, double[] statY, double pidw, int nidw) {
        int i;
        double[] distances = IDW.calcDistances(entityX, entityY, statX, statY, pidw);
        double[] weights = IDW.calcWeights(distances);
        int counter = 0;
        int nstat = weights.length;
        int[] temp = new int[nstat];
        double weightsum = 0.0;
        int[] indicator = new int[nstat];
        for (i = 0; i < nstat; ++i) {
            counter = 0;
            for (int k = 0; k < nstat; ++k) {
                if (!(weights[i] > weights[k])) continue;
                ++counter;
            }
            temp[i] = counter;
        }
        for (i = 0; i < nstat; ++i) {
            if (temp[i] >= nstat - nidw) continue;
            weights[i] = 0.0;
        }
        for (i = 0; i < nstat; ++i) {
            weightsum += weights[i];
        }
        for (i = 0; i < nstat; ++i) {
            weights[i] = weights[i] / weightsum;
        }
        return weights;
    }

    public static double[] calcIDWeights(double entityX, double entityY, double[] statX, double[] statY, double pidw) {
        int i;
        double[] distances = IDW.calcDistances(entityX, entityY, statX, statY, pidw);
        double[] weights = IDW.calcWeights(distances);
        int counter = 0;
        int nstat = weights.length;
        int[] temp = new int[nstat];
        double weightsum = 0.0;
        int[] indicator = new int[nstat];
        for (i = 0; i < nstat; ++i) {
            counter = 0;
            for (int k = 0; k < nstat; ++k) {
                if (!(weights[i] > weights[k])) continue;
                ++counter;
            }
            temp[i] = counter;
        }
        for (i = 0; i < nstat; ++i) {
            weightsum += weights[i];
        }
        for (i = 0; i < nstat; ++i) {
            weights[i] = weights[i] / weightsum;
        }
        return weights;
    }

    public static int[] computeWeightArray(double[] weights) {
        boolean counter = false;
        int pos = 0;
        int nstat = weights.length;
        int[] wArray = new int[nstat];
        double[] tempWeight = new double[nstat];
        for (int i = 0; i < nstat; ++i) {
            tempWeight[i] = weights[i];
        }
        double maxWeight = -9.0;
        for (int j = 0; j < nstat; ++j) {
            for (int i = 0; i < nstat; ++i) {
                counter = false;
                if (!(tempWeight[i] > maxWeight)) continue;
                maxWeight = weights[i];
                pos = i;
            }
            tempWeight[pos] = -9.0;
            maxWeight = -9.0;
            wArray[j] = pos;
        }
        return wArray;
    }
}

