/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning.kernels;

import Jama.Matrix;
import jams.components.machineLearning.kernels.Kernel;

public class SimpleNeuralNetwork
extends Kernel {
    Matrix nnKernel = null;

    public SimpleNeuralNetwork(int inputDim) {
        this.inputDim = inputDim;
        this.parameterCount = 2;
        this.KernelParameterCount = 2;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        this.KernelParameterNames[0] = "bias";
        this.KernelParameterNames[1] = "sigma";
        return this.KernelParameterNames;
    }

    @Override
    public boolean SetParameter(double[] theta) {
        if (theta.length < this.parameterCount) {
            return false;
        }
        this.theta = theta;
        this.nnKernel = new Matrix(this.inputDim + 1, this.inputDim + 1, 0.0);
        for (int i = 0; i < this.parameterCount; ++i) {
            this.nnKernel.set(i, i, 1.0);
        }
        this.nnKernel.set(this.inputDim, this.inputDim, theta[0]);
        return true;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        Matrix mx = new Matrix(1, x.length + 1);
        Matrix my = new Matrix(y.length + 1, 1);
        for (int i = 0; i < x.length; ++i) {
            mx.set(0, i + 1, x[i]);
            my.set(i + 1, 0, y[i]);
        }
        mx.set(0, 0, 1.0);
        my.set(0, 0, 1.0);
        double value1 = mx.times(this.nnKernel).times(my).get(0, 0);
        double value2 = mx.times(this.nnKernel).times(mx.transpose()).get(0, 0);
        double value3 = my.transpose().times(this.nnKernel).times(my).get(0, 0);
        double noise = 0.0;
        if (index1 == index2) {
            noise = this.theta[1] * this.theta[1];
        }
        return 0.6366197723675814 * Math.asin(2.0 * value1 / Math.sqrt((1.0 + 2.0 * value2) * (1.0 + 2.0 * value3))) + noise;
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

