/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning.kernels;

import Jama.Matrix;
import jams.components.machineLearning.kernels.MeanModell;

public class LinearMeanModell
extends MeanModell {
    public LinearMeanModell(int inputSize) {
        this.inputSize = inputSize;
        this.parameterCount = inputSize + 1;
    }

    @Override
    public String[] getMeanModelParameterNames() {
        this.meanModelParameterNames = new String[this.inputSize + 1];
        for (int i = 0; i < this.inputSize; ++i) {
            this.meanModelParameterNames[i] = "linRegCoeff_" + i;
        }
        this.meanModelParameterNames[this.inputSize] = "linRegCoeff_bias";
        return this.meanModelParameterNames;
    }

    @Override
    public void create(double[][] data, double[] predict) {
        int n = data.length;
        int m = data[0].length;
        Matrix A = new Matrix(n, m + 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                A.set(i, j, data[i][j]);
            }
            A.set(i, m, 1.0);
        }
        Matrix b = new Matrix(n, 1);
        for (int i = 0; i < n; ++i) {
            b.set(i, 0, predict[i]);
        }
        Matrix reg = A.transpose().times(A).solve(A.transpose().times(b));
        this.beta = reg.getColumnPackedCopy();
    }

    @Override
    public Matrix Transform(double[][] data, double[] result) {
        int i;
        double sum = 0.0;
        Matrix transformed = new Matrix(result.length, 1);
        for (i = 0; i < data.length; ++i) {
            sum = this.beta[this.beta.length - 1];
            for (int j = 0; j < this.inputSize; ++j) {
                sum += this.beta[j] * data[i][j];
            }
            transformed.set(i, 0, result[i] - sum);
        }
        for (i = 0; i < data.length; ++i) {
            transformed.set(i, 0, transformed.get(i, 0));
        }
        return transformed;
    }

    @Override
    public double[] ReTransform(double[][] data, Matrix prediction) {
        double sum = 0.0;
        double[] transformed = new double[prediction.getRowDimension()];
        for (int i = 0; i < data.length; ++i) {
            sum = this.beta[this.beta.length - 1];
            for (int j = 0; j < this.inputSize; ++j) {
                sum += this.beta[j] * data[i][j];
            }
            transformed[i] = prediction.get(i, 0) + sum;
        }
        return transformed;
    }
}

