/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;

public class SplitValidation
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Integer TrainingSetSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Entity Data;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Entity trainingData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Entity validationData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Boolean enable;

    public void init() {
    }

    private void singleRun() {
        Component comp;
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void run() {
        if (this.enable != null && !this.enable.getValue()) {
            this.singleRun();
            return;
        }
        double[][] data = null;
        double[] predict = null;
        try {
            data = (double[][])this.Data.getObject("data");
            predict = (double[])this.Data.getObject("predict");
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("Could not find dataset" + e.toString());
        }
        this.getModel().getRuntime().sendInfoMsg("Split Validation");
        int n = data.length;
        int m = this.TrainingSetSize.getValue();
        if (m > n) {
            this.getModel().getRuntime().sendHalt("training set size is larger than number of observations");
        }
        if (m <= 0) {
            this.getModel().getRuntime().sendHalt("training set size is less or equal to zero");
        }
        double[][] valData = new double[n - m][];
        double[] valPredict = new double[n - m];
        double[][] trainData = new double[m][];
        double[] trainPredict = new double[m];
        for (int j = 0; j < data.length; ++j) {
            if (j >= m && j < n) {
                valData[j - m] = data[j];
                valPredict[j - m] = predict[j];
            }
            if (j < 0 || j >= m) continue;
            trainData[j] = data[j];
            trainPredict[j] = predict[j];
        }
        this.trainingData.setObject("data", (Object)trainData);
        this.trainingData.setObject("predict", (Object)trainPredict);
        this.validationData.setObject("data", (Object)valData);
        this.validationData.setObject("predict", (Object)valPredict);
        this.singleRun();
    }
}

