/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.components.machineLearning.ActivationFunction;
import jams.components.machineLearning.Exponential;
import jams.components.machineLearning.LinApprox;
import jams.components.machineLearning.Matrix;
import jams.components.machineLearning.Polynom;
import java.util.Vector;

public class GenericFunction {
    private static long nextID = 0L;
    private ActivationFunction Function = null;
    private ActivationFunction dFunction = null;
    private String description;
    private String name;
    private int polyDegree;
    private int functionType;
    public Long id = null;
    private Matrix M;
    private static Vector<Long> idList = new Vector();

    public GenericFunction(Long id, String name, String description, int functionType, int polyDegree, Matrix M) {
        this.registerID(id);
        if (functionType == 2) {
            this.Function = new Exponential(M);
        } else if (functionType == 3) {
            this.Function = new LinApprox(M);
        } else if (functionType == 1) {
            this.Function = new Polynom(M, polyDegree);
        }
        this.dFunction = this.Function.derive();
        this.description = description;
        this.name = name;
        this.polyDegree = polyDegree;
        this.functionType = functionType;
        this.M = M;
    }

    public GenericFunction(ActivationFunction af) {
        this.Function = af;
        this.dFunction = this.Function.derive();
        this.description = "";
        this.name = "";
        this.polyDegree = 1;
        this.functionType = af.getType();
        this.M = null;
    }

    public GenericFunction(String name, String description, int functionType, int polyDegree, Matrix M) {
        this(GenericFunction.getNewID(), name, description, functionType, polyDegree, M);
    }

    private static Long getNewID() {
        Long id = new Long(nextID++);
        while (idList.contains(id)) {
            id = new Long(nextID++);
        }
        return id;
    }

    private void registerID(Long id) {
        this.id = id;
        idList.add(id);
    }

    public ActivationFunction getFunction() {
        return this.Function;
    }

    public ActivationFunction getDFunction() {
        return this.dFunction;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPolyDegree() {
        return this.polyDegree;
    }

    public Matrix getMatrix() {
        return this.M;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public Long getID() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFunctionType(int functionType) {
        this.functionType = functionType;
    }

    public void setPolyDegree(int polyDegree) {
        this.polyDegree = polyDegree;
    }

    public void setMatrix(Matrix M) {
        this.M = M;
    }

    public String toString() {
        return this.name;
    }
}

