/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.FileTools;
import jams.tools.JAMSTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DataLoader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of input file")
    public Attribute.String datafile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of input data columns")
    public Attribute.Integer ExampleLength;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of time steps to consider")
    public Attribute.Integer relevantTime;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Entity containing input and prediction data")
    public Attribute.Entity Data;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Time steps to shift the input data")
    public Attribute.Integer dataShift;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Semicolon separated list of row ids to negelect")
    public Attribute.String Gaps;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Value for missing data", defaultValue="-9999")
    public Attribute.Double missingDataValue;

    public void init() {
        BufferedReader reader = null;
        HashMap<Integer, double[]> rawData = new HashMap<Integer, double[]>();
        HashMap<Integer, double[]> rawPredict = new HashMap<Integer, double[]>();
        Vector<Integer> excluded = new Vector<Integer>();
        if (this.Gaps != null) {
            StringTokenizer GapTokenizer = new StringTokenizer(this.Gaps.getValue(), ";");
            while (GapTokenizer.hasMoreElements()) {
                excluded.add(new Integer(GapTokenizer.nextToken()));
            }
        }
        int ExamplLength = this.ExampleLength.getValue();
        int numOfExampl = 0;
        int RelevantTime = this.relevantTime.getValue();
        if (ExamplLength <= 0) {
            this.getModel().getRuntime().sendHalt("inputDimension is less or equal zero!");
            return;
        }
        if (RelevantTime <= 0) {
            this.getModel().getRuntime().sendHalt("Relevant timesteps is less or equal zero!");
            return;
        }
        try {
            reader = new BufferedReader(new FileReader(FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getAbsolutePath(), (String)this.datafile.getValue())));
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().sendHalt("could not open datafile " + this.datafile.getValue() + "; wrong path?");
            JAMSTools.handle((Throwable)ioe);
            return;
        }
        String nextString = null;
        boolean isExcluded = false;
        try {
            int i = 0;
            while ((nextString = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(nextString, "\t");
                double[] Example = new double[ExamplLength];
                double[] Predict = new double[1];
                try {
                    for (int j = 0; j < ExamplLength; ++j) {
                        Example[j] = new Double(st.nextToken());
                        if (Example[j] != this.missingDataValue.getValue()) continue;
                        excluded.add(i);
                        isExcluded = true;
                    }
                    Predict[0] = new Double(st.nextToken());
                    if (!isExcluded && Predict[0] == this.missingDataValue.getValue()) {
                        excluded.add(i);
                    }
                    isExcluded = false;
                }
                catch (NoSuchElementException e) {
                    this.getModel().getRuntime().sendHalt("Error in row " + i + "\nstop reading! (not enough numbers in row\nExpected " + (ExamplLength + 1) + ")");
                    JAMSTools.handle((Throwable)e);
                    break;
                }
                catch (NumberFormatException e) {
                    this.getModel().getRuntime().sendHalt("Error in row " + i + "\nstop reading!\nNot a number!!");
                    JAMSTools.handle((Throwable)e);
                    break;
                }
                rawData.put(new Integer(i), Example);
                rawPredict.put(new Integer(i), Predict);
                ++i;
            }
            numOfExampl = i;
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().sendHalt("could not read datafile " + this.datafile.getValue());
            JAMSTools.handle((Throwable)ioe);
        }
        Vector<double[]> data = new Vector<double[]>();
        Vector<Double> predict = new Vector<Double>();
        for (int i = 0; i < numOfExampl - RelevantTime + 1; ++i) {
            isExcluded = false;
            double[] Sample = new double[RelevantTime * ExamplLength];
            for (int j = 0; j < RelevantTime; ++j) {
                if (excluded.contains(new Integer(i + j))) {
                    isExcluded = true;
                    break;
                }
                double[] entry = (double[])rawData.get(new Integer(i + j));
                for (int k = 0; k < ExamplLength; ++k) {
                    Sample[j * ExamplLength + k] = entry[k];
                }
            }
            if (isExcluded || i + RelevantTime - 1 + this.dataShift.getValue() < 0) continue;
            if (excluded.contains(new Integer(i + RelevantTime - 1 + this.dataShift.getValue()))) {
                isExcluded = true;
                continue;
            }
            data.add(Sample);
            predict.add(((double[])rawPredict.get(new Integer(i + RelevantTime - 1 + this.dataShift.getValue())))[0]);
        }
        double[][] dataAsArray = new double[data.size()][RelevantTime * ExamplLength];
        double[] predictAsArray = new double[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            dataAsArray[i] = (double[])data.get(i);
            predictAsArray[i] = (Double)predict.get(i);
        }
        this.Data.setObject("data", (Object)dataAsArray);
        this.Data.setObject("predict", (Object)predictAsArray);
    }
}

