/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import java.time.LocalDate;
import java.time.ZoneOffset;

public class CustomCalendar360_ {
    private static final int DAYS_PER_MONTH = 30;
    private static final int MONTHS_PER_YEAR = 12;
    private static final int DAYS_PER_YEAR = 360;
    private static final int BASE_YEAR = 1970;
    private static final LocalDate CUSTOM_EPOCH = LocalDate.of(1970, 1, 1);
    private int year;
    private int month;
    private int day;

    public CustomCalendar360_(int year, int month, int day) {
        if (month < 1 || month > 12 || day < 1 || day > 30) {
            throw new IllegalArgumentException("Invalid date in custom calendar");
        }
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static CustomCalendar360_ fromGregorian(LocalDate date) {
        long daysSinceEpoch = date.toEpochDay() - CUSTOM_EPOCH.toEpochDay();
        int customYear = (int)(daysSinceEpoch / 360L) + 1970;
        int remainingDays = (int)(daysSinceEpoch % 360L);
        if (remainingDays < 0) {
            --customYear;
            remainingDays += 360;
        }
        int customMonth = remainingDays / 30 + 1;
        int customDay = remainingDays % 30 + 1;
        return new CustomCalendar360_(customYear, customMonth, customDay);
    }

    public LocalDate toGregorian() {
        long totalDays = (long)(this.year - 1970) * 360L + (long)((this.month - 1) * 30) + (long)(this.day - 1);
        return CUSTOM_EPOCH.plusDays(totalDays);
    }

    public void addDays(int days) {
        long totalDays = (long)(this.year - 1970) * 360L + (long)((this.month - 1) * 30) + (long)(this.day - 1) + (long)days;
        this.year = (int)(totalDays / 360L) + 1970;
        int remainingDays = (int)(totalDays % 360L);
        if (remainingDays < 0) {
            --this.year;
            remainingDays += 360;
        }
        this.month = remainingDays / 30 + 1;
        this.day = remainingDays % 30 + 1;
    }

    public long getTimeInMillis() {
        LocalDate gregorianDate = this.toGregorian();
        return gregorianDate.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    public long calculateOffset(CustomCalendar360_ other) {
        long totalDaysThis = (long)(this.year - 1970) * 360L + (long)((this.month - 1) * 30) + (long)(this.day - 1);
        long totalDaysOther = (long)(other.year - 1970) * 360L + (long)((other.month - 1) * 30) + (long)(other.day - 1);
        return totalDaysThis - totalDaysOther;
    }

    public String toCustomDateString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public static void main(String[] args) {
        CustomCalendar360_ customDate1 = new CustomCalendar360_(1975, 2, 1);
        CustomCalendar360_ customDate2 = new CustomCalendar360_(1974, 12, 15);
        System.out.println("Custom Date 1: " + customDate1.toCustomDateString());
        System.out.println("Custom Date 2: " + customDate2.toCustomDateString());
        long offset = customDate1.calculateOffset(customDate2);
        System.out.println("Offset (days) between Date 1 and Date 2: " + offset);
        LocalDate gregorianDate1 = customDate1.toGregorian();
        System.out.println("Equivalent Gregorian Date 1: " + gregorianDate1);
        customDate1.addDays(-10);
        System.out.println("Custom Date 1 after subtracting 10 days: " + customDate1.toCustomDateString());
        System.out.println("Time in milliseconds for Date 1: " + customDate1.getTimeInMillis());
    }
}

