/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.components.indices.AbstractDICalc;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Soil Moisture Deficit Index (SMDI) Calculator", author="Sven Kralisch", description="This component calculates the Soil Moisture Deficit Index (SMDI) based on\nNarasimhan, B. & Srinivasan, R. (2005) Development and evaluation of Soil Moisture Deficit Index (SMDI) and Evapotranspiration Deficit Index (ETDI) for agricultural drought monitoring. Agricultural and Forest Meteorology 133(1\u20134), 69\u201388. doi:10.1016/j.agrformet.2005.07.012", date="2017-04-17", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class SMDI_Calc
extends AbstractDICalc {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of collected soil water content values")
    public Attribute.DoubleArray swValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Statistics for SMDI calculation")
    public Attribute.Object smdiStats;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current soil water average")
    public Attribute.Double currentSW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Soil water deficit")
    public Attribute.Double sd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Soil moisture deficit index (SMDI)")
    public Attribute.Double smdi;

    @Override
    public void run() {
        AbstractDICalc.Stats stats;
        if (this.smdiStats.getValue() == null) {
            stats = this.calcStats(this.swValues.getValue());
            this.smdiStats.setValue((Object)stats);
        } else {
            stats = (AbstractDICalc.Stats)this.smdiStats.getValue();
        }
        int day = this.date.get(6);
        if (day > 365) {
            return;
        }
        if (day % this.tres != 0) {
            return;
        }
        int timeIndex = day / this.tres - 1;
        int c = this.counter.getValue();
        double sw = this.swValues.getValue()[c];
        this.counter.setValue(c + 1);
        double msw = stats.median[timeIndex];
        double min = stats.min[timeIndex];
        double max = stats.max[timeIndex];
        double sd_ = sw <= msw ? (msw == min ? 0.0 : 100.0 * (sw - msw) / (msw - min)) : (msw == max ? 0.0 : 100.0 * (sw - msw) / (max - msw));
        double smdi_ = 0.5 * this.smdi.getValue() + sd_ / 50.0;
        smdi_ = Math.max(smdi_, -4.0);
        smdi_ = Math.min(smdi_, 4.0);
        this.smdi.setValue(smdi_);
        this.sd.setValue(sd_);
        this.currentSW.setValue(sw);
    }
}

