/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

@JAMSComponentDescription(title="Timeseries plot", author="Sven Kralisch", date="2014-01-23", description="This component creates a graphical plot of time series data, e.g. precipitation and runoff over time.", version="1.0_2")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2006-09-18", comment="Initial version"), @VersionComments.Entry(version="1.0_1", date="2013-08-13", comment="Changed default cache size"), @VersionComments.Entry(version="1.0_2", date="2014-01-23", comment="- Aligned font sizes for left/right axis labels\n- Added horizotal grid line and display option\n- Added legend positioning option")})
public class TSPlot
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for plot. Default: component name")
    public Attribute.String plotTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Static title strings for left graphs. Number of entries must be identical to number of plottet values (valueLeft).", defaultValue="titleLeft")
    public Attribute.StringArray titleLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Dynamic addon title strings added after left static titles (titleLeft)")
    public Attribute.StringArray varTitleLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Static title strings for right graphs", defaultValue="titleRight")
    public Attribute.StringArray titleRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Colors for left graphs (yellow, orange, red, pink, magenta, cyan, yellow, green, lightgray, gray, black). Number of entries must be identical to number of plottet values (valueLeft).", defaultValue="blue;red")
    public Attribute.StringArray colorLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Colors for right graphs (yellow, orange, red, pink, magenta, cyan, yellow, green, lightgray, gray, black). Number of entries must be identical to number of plottet values (valueRight).", defaultValue="red")
    public Attribute.StringArray colorRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Graph type for left y axis graphs", defaultValue="0")
    public Attribute.Integer typeLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Graph type for right y axis graphs", defaultValue="0")
    public Attribute.Integer typeRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for x axis", defaultValue="Time")
    public Attribute.String xAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for left y axis", defaultValue="LeftTitle")
    public Attribute.String leftAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Title string for right y axis", defaultValue="RightTitle")
    public Attribute.String rightAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, defaultValue="0", description="Paint inverted right y axis?")
    public Attribute.Boolean rightAxisInverted;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Date format", defaultValue="dd-MM-yyyy")
    public Attribute.String dateFormat;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values to be plotted on left y-axis")
    public Attribute.Double[] valueLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values to be plotted on right y-axis")
    public Attribute.Double[] valueRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Plot data, after cacheSize values have been collected", defaultValue="5")
    public Attribute.Integer cacheSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Paint horizontal/vertical grid lines?", defaultValue="true")
    public Attribute.Boolean paintGridLines;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Paint legend right of the plot?", defaultValue="false")
    public Attribute.Boolean legendRight;
    TimeSeries[] tsLeft;
    TimeSeries[] tsRight;
    transient TimeSeriesCollection dataset1;
    transient TimeSeriesCollection dataset2;
    transient XYItemRenderer rightRenderer;
    transient XYItemRenderer leftRenderer;
    transient XYPlot plot;
    transient JFreeChart chart;
    int graphCountLeft = 0;
    int graphCountRight = 0;
    HashMap<String, Color> colorTable = new HashMap();
    long[] timeStamps;
    double[] dataValuesLeft;
    double[] dataValuesRight;
    int count;

    public TSPlot() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
    }

    public JPanel getPanel() {
        this.dataset1 = new TimeSeriesCollection();
        this.dataset2 = new TimeSeriesCollection();
        String title = this.getInstanceName();
        if (this.plotTitle != null) {
            title = this.plotTitle.getValue();
        }
        this.chart = ChartFactory.createTimeSeriesChart((String)title, (String)this.xAxisTitle.getValue(), (String)this.leftAxisTitle.getValue(), (XYDataset)this.dataset1, (boolean)true, (boolean)true, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(this.chart, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)chartPanel, "Center");
        return panel;
    }

    private XYItemRenderer getRenderer(int type) {
        switch (type) {
            case 0: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                return lsr;
            }
            case 1: {
                XYBarRenderer renderer = new XYBarRenderer();
                StandardXYBarPainter painter = new StandardXYBarPainter();
                renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
                renderer.setDrawBarOutline(false);
                renderer.setShadowVisible(false);
                return renderer;
            }
            case 2: {
                return new XYAreaRenderer();
            }
            case 3: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(true);
                return lsr;
            }
            case 4: {
                XYDotRenderer dotR = new XYDotRenderer();
                dotR.setDefaultEntityRadius(2);
                return dotR;
            }
            case 5: {
                return new XYDifferenceRenderer();
            }
            case 6: {
                return new XYStepRenderer();
            }
            case 7: {
                return new XYStepAreaRenderer();
            }
        }
        XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
        lsr.setBaseShapesVisible(false);
        return lsr;
    }

    public void init() {
        if (this.dataset1 != null) {
            this.dataset1.removeAllSeries();
        }
        if (this.dataset2 != null) {
            this.dataset2.removeAllSeries();
        }
        if (this.chart != null) {
            this.plot = this.chart.getXYPlot();
            this.chart.getPlot().setBackgroundPaint((Paint)Color.white);
            this.plot.setDomainGridlinePaint((Paint)Color.gray);
            this.plot.setRangeGridlinePaint((Paint)Color.gray);
            this.plot.setDomainGridlinesVisible(this.paintGridLines.getValue());
            this.plot.setRangeGridlinesVisible(this.paintGridLines.getValue());
            this.chart.getLegend().setMargin(0.0, 10.0, 10.0, 10.0);
            if (this.legendRight.getValue()) {
                LegendTitle legend = this.chart.getLegend();
                legend.setPosition(RectangleEdge.RIGHT);
            }
            DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
            dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.dateFormat.getValue()));
            Font labelFont = this.plot.getRangeAxis().getLabelFont();
            this.leftRenderer = this.getRenderer(this.typeLeft.getValue());
            this.plot.setRenderer(0, this.leftRenderer);
            if (this.valueLeft == null) {
                this.getModel().getRuntime().sendErrorMsg(JAMS.i18n((String)"no_value_for_time_series_plot"));
                return;
            }
            this.graphCountLeft = this.valueLeft.length;
            this.tsLeft = new TimeSeries[this.graphCountLeft];
            for (int i = 0; i < this.graphCountLeft; ++i) {
                String legendEntry = "";
                if (this.titleLeft != null && this.titleLeft.getValue().length > i) {
                    legendEntry = this.titleLeft.getValue()[i];
                }
                if (this.varTitleLeft != null && this.varTitleLeft.getValue().length > i) {
                    legendEntry = legendEntry + this.varTitleLeft.getValue()[i];
                }
                if (this.colorLeft != null && this.colorLeft.getValue().length > i) {
                    this.leftRenderer.setSeriesPaint(i, (Paint)this.colorTable.get(this.colorLeft.getValue()[i]));
                }
                this.tsLeft[i] = new TimeSeries((Comparable)((Object)legendEntry));
                this.dataset1.addSeries(this.tsLeft[i]);
            }
            if (this.valueRight != null) {
                NumberAxis axis2 = new NumberAxis(this.rightAxisTitle.getValue());
                axis2.setLabelFont(labelFont);
                axis2.setInverted(this.rightAxisInverted.getValue());
                this.plot.setRangeAxis(1, (ValueAxis)axis2);
                this.plot.setDataset(1, (XYDataset)this.dataset2);
                this.plot.mapDatasetToRangeAxis(1, 1);
                this.rightRenderer = this.getRenderer(this.typeRight.getValue());
                this.plot.setRenderer(1, this.rightRenderer);
                this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
                this.graphCountRight = this.valueRight.length;
                this.tsRight = new TimeSeries[this.graphCountRight];
                for (int i = 0; i < this.graphCountRight; ++i) {
                    if (this.colorRight != null && this.colorRight.getValue().length >= i) {
                        this.rightRenderer.setSeriesPaint(i, (Paint)this.colorTable.get(this.colorRight.getValue()[i]));
                    }
                    String title = "";
                    if (this.titleRight != null && this.titleRight.getValue().length > i) {
                        title = this.titleRight.getValue()[i];
                    }
                    this.tsRight[i] = new TimeSeries((Comparable)((Object)title));
                    this.dataset2.addSeries(this.tsRight[i]);
                }
            }
        }
        int cacheSize = this.cacheSize.getValue();
        this.timeStamps = new long[cacheSize];
        this.dataValuesRight = new double[cacheSize * this.graphCountRight];
        this.dataValuesLeft = new double[cacheSize * this.graphCountLeft];
        this.count = 0;
    }

    public void run() {
        double value;
        int i;
        if (this.time == null) {
            this.getModel().getRuntime().sendErrorMsg(JAMS.i18n((String)"no_time_value_was_provided_for_time_series_plot"));
        }
        this.timeStamps[this.count] = this.time.getTimeInMillis();
        int offsetRight = this.count * this.graphCountRight;
        int offsetLeft = this.count * this.graphCountLeft;
        for (i = 0; i < this.graphCountRight; ++i) {
            value = this.valueRight[i].getValue();
            if (value == JAMS.getMissingDataValue()) {
                value = Double.NaN;
            }
            this.dataValuesRight[offsetRight + i] = value;
        }
        for (i = 0; i < this.graphCountLeft; ++i) {
            value = this.valueLeft[i].getValue();
            if (value == JAMS.getMissingDataValue()) {
                value = Double.NaN;
            }
            this.dataValuesLeft[offsetLeft + i] = value;
        }
        if (++this.count == this.cacheSize.getValue()) {
            this.plotData();
            this.count = 0;
        }
    }

    private void plotData() {
        try {
            for (int i = 0; i < this.count; ++i) {
                int j;
                Second second = new Second(new Date(this.timeStamps[i]));
                for (j = 0; j < this.graphCountRight; ++j) {
                    this.tsRight[j].add((RegularTimePeriod)second, this.dataValuesRight[i * this.graphCountRight + j]);
                }
                for (j = 0; j < this.graphCountLeft; ++j) {
                    this.tsLeft[j].add((RegularTimePeriod)second, this.dataValuesLeft[i * this.graphCountLeft + j]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.plotData();
    }

    public void restore() {
        Iterator iter;
        int i;
        List[] leftLists = null;
        List[] rightLists = null;
        if (this.tsLeft != null) {
            leftLists = new List[this.tsLeft.length];
            for (i = 0; i < this.tsLeft.length; ++i) {
                leftLists[i] = this.tsLeft[i].getItems();
            }
        }
        if (this.tsRight != null) {
            rightLists = new List[this.tsRight.length];
            for (i = 0; i < this.tsRight.length; ++i) {
                rightLists[i] = this.tsRight[i].getItems();
            }
        }
        this.init();
        if (this.tsLeft != null) {
            for (i = 0; i < this.tsLeft.length; ++i) {
                iter = leftLists[i].iterator();
                while (iter.hasNext()) {
                    this.tsLeft[i].add((TimeSeriesDataItem)iter.next());
                }
            }
        }
        if (this.tsRight != null) {
            for (i = 0; i < this.tsRight.length; ++i) {
                iter = rightLists[i].iterator();
                while (iter.hasNext()) {
                    this.tsRight[i].add((TimeSeriesDataItem)iter.next());
                }
            }
        }
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        this.plotData();
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        this.plotData();
        this.count = 0;
        objOut.defaultWriteObject();
    }
}

