/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import jams.JAMS;
import jams.data.Attribute;
import jams.io.ParameterProcessor;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@JAMSComponentDescription(author="Sven Kralisch", description="Print list of all parameter values", date="2014-01-17", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2014-01-17", comment="Initial version")})
public class ParameterOutput
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, defaultValue="50", description="Indentation of parameter values")
    public Attribute.Integer indent;
    private JScrollPane scrollPanel;
    private JTextArea logArea;
    private JPanel panel;

    public JPanel getPanel() {
        if (this.panel == null) {
            this.createPanel();
        }
        return this.panel;
    }

    public void init() {
        if (this.panel != null) {
            String header = "#" + JAMS.i18n((String)"JAMS_model_parameter_file");
            header = header + "\n#" + new SimpleDateFormat().format(new Date()) + "\n";
            this.logArea.append(header);
            HashMap componentHash = ParameterProcessor.getAttributeHash((Document)this.getModel().getRuntime().getModelDocument());
            TreeSet<String> values = new TreeSet<String>();
            for (String componentName : componentHash.keySet()) {
                HashMap attributeHash = (HashMap)componentHash.get(componentName);
                for (String attributeName : attributeHash.keySet()) {
                    Element attribute = (Element)attributeHash.get(attributeName);
                    String aName = attribute.getAttribute("name");
                    if (componentName.equals(aName)) continue;
                    String s = String.format("%" + -this.indent.getValue() + "s= ", componentName + "." + aName) + attribute.getAttribute("value") + "\n";
                    values.add(s);
                }
            }
            for (String s : values) {
                this.logArea.append(s);
            }
        }
    }

    private void createPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.scrollPanel = new JScrollPane();
        this.logArea = new JTextArea();
        this.logArea.setColumns(20);
        this.logArea.setRows(5);
        this.logArea.setLineWrap(false);
        this.logArea.setEditable(false);
        this.logArea.setFont(JAMS.STANDARD_FONT);
        this.scrollPanel.setViewportView(this.logArea);
        this.panel.add((Component)this.scrollPanel, "Center");
    }
}

