/*
 * Decompiled with CFR 0.152.
 */
package jams.components.datatransfer;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="DoubleTransferFraction", author="Sven Kralisch", description="Component for simply transferring multiple double attributes) to a target entity. In addition, options to transfer only fractions of source data and optional modification of source data are possible. Can be used to implement a simple routing mechanism (e.g. HRU to HRU or HRU to reach) by taking a source entity's double data and moving it to the specified target attributes.", version="1.0_0", date="2012-09-27")
public class DoubleTransferFraction
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Target entity")
    public Attribute.Entity target;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Data to be transferred")
    public Attribute.Double[] values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Target entity's receiving attributes")
    public Attribute.String[] inNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Fractions of data to be transferred. One fractionvalue per transferred value is required.")
    public Attribute.Double[] fraction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Remove transferred data from source values?", defaultValue="false")
    public Attribute.Boolean removeFromSource;

    public void run() {
        if (!this.target.isEmpty()) {
            for (int i = 0; i < this.values.length; ++i) {
                double x = this.values[i].getValue() * this.fraction[i].getValue();
                this.target.setDouble(this.inNames[i].getValue(), this.target.getDouble(this.inNames[i].getValue()) + x);
                if (!this.removeFromSource.getValue()) continue;
                this.values[i].setValue(this.values[i].getValue() - x);
            }
        }
    }
}

