/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.io.IOException;
import java.io.ObjectInputStream;

@JAMSComponentDescription(title="DoubleDivide", author="Sven Kralisch", description="Divide a double value by another one and return the result", date="2016-05-18", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class DoubleDivide
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="First operand")
    public Attribute.Double[] d1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Second operand")
    public Attribute.Double[] d2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Result of d1/d2")
    public Attribute.Double[] result;
    transient Runnable job;

    public void init() {
        if (this.d1.length == this.d2.length) {
            this.job = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < DoubleDivide.this.d1.length; ++i) {
                        DoubleDivide.this.result[i].setValue(DoubleDivide.this.d1[i].getValue() / DoubleDivide.this.d2[i].getValue());
                    }
                }
            };
        } else if (this.d2.length == 1) {
            this.job = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < DoubleDivide.this.d1.length; ++i) {
                        DoubleDivide.this.result[i].setValue(DoubleDivide.this.d1[i].getValue() / DoubleDivide.this.d2[0].getValue());
                    }
                }
            };
        } else {
            this.getModel().getRuntime().sendHalt("Attribute d2 has wrong length, should be 1 or length of d1");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public void run() {
        this.job.run();
    }
}

