/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class GeometryFactory
implements Serializable {
    private static final long serialVersionUID = -6820524753094095635L;
    private PrecisionModel precisionModel;
    private CoordinateSequenceFactory coordinateSequenceFactory;
    private int SRID;

    public static Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.getFactory().createPoint(coord);
    }

    public GeometryFactory(PrecisionModel precisionModel, int SRID, CoordinateSequenceFactory coordinateSequenceFactory) {
        this.precisionModel = precisionModel;
        this.coordinateSequenceFactory = coordinateSequenceFactory;
        this.SRID = SRID;
    }

    public GeometryFactory(CoordinateSequenceFactory coordinateSequenceFactory) {
        this(new PrecisionModel(), 0, coordinateSequenceFactory);
    }

    public GeometryFactory(PrecisionModel precisionModel) {
        this(precisionModel, 0, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory(PrecisionModel precisionModel, int SRID) {
        this(precisionModel, SRID, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    private static CoordinateSequenceFactory getDefaultCoordinateSequenceFactory() {
        return CoordinateArraySequenceFactory.instance();
    }

    public static Point[] toPointArray(Collection points) {
        Point[] pointArray = new Point[points.size()];
        return points.toArray(pointArray);
    }

    public static Geometry[] toGeometryArray(Collection geometries) {
        if (geometries == null) {
            return null;
        }
        Geometry[] geometryArray = new Geometry[geometries.size()];
        return geometries.toArray(geometryArray);
    }

    public static LinearRing[] toLinearRingArray(Collection linearRings) {
        LinearRing[] linearRingArray = new LinearRing[linearRings.size()];
        return linearRings.toArray(linearRingArray);
    }

    public static LineString[] toLineStringArray(Collection lineStrings) {
        LineString[] lineStringArray = new LineString[lineStrings.size()];
        return lineStrings.toArray(lineStringArray);
    }

    public static Polygon[] toPolygonArray(Collection polygons) {
        Polygon[] polygonArray = new Polygon[polygons.size()];
        return polygons.toArray(polygonArray);
    }

    public static MultiPolygon[] toMultiPolygonArray(Collection multiPolygons) {
        MultiPolygon[] multiPolygonArray = new MultiPolygon[multiPolygons.size()];
        return multiPolygons.toArray(multiPolygonArray);
    }

    public static MultiLineString[] toMultiLineStringArray(Collection multiLineStrings) {
        MultiLineString[] multiLineStringArray = new MultiLineString[multiLineStrings.size()];
        return multiLineStrings.toArray(multiLineStringArray);
    }

    public static MultiPoint[] toMultiPointArray(Collection multiPoints) {
        MultiPoint[] multiPointArray = new MultiPoint[multiPoints.size()];
        return multiPoints.toArray(multiPointArray);
    }

    public Geometry toGeometry(Envelope envelope) {
        if (envelope.isNull()) {
            return this.createPoint((CoordinateSequence)null);
        }
        if (envelope.getMinX() == envelope.getMaxX() && envelope.getMinY() == envelope.getMaxY()) {
            return this.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        if (envelope.getMinX() == envelope.getMaxX() || envelope.getMinY() == envelope.getMaxY()) {
            return this.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())});
        }
        return this.createPolygon(this.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public Point createPoint(Coordinate coordinate) {
        return this.createPoint(coordinate != null ? this.getCoordinateSequenceFactory().create(new Coordinate[]{coordinate}) : null);
    }

    public Point createPoint(CoordinateSequence coordinates) {
        return new Point(coordinates, this);
    }

    public MultiLineString createMultiLineString(LineString[] lineStrings) {
        return new MultiLineString(lineStrings, this);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        return new GeometryCollection(geometries, this);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygons) {
        return new MultiPolygon(polygons, this);
    }

    public LinearRing createLinearRing(Coordinate[] coordinates) {
        return this.createLinearRing(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public LinearRing createLinearRing(CoordinateSequence coordinates) {
        return new LinearRing(coordinates, this);
    }

    public MultiPoint createMultiPoint(Point[] point) {
        return new MultiPoint(point, this);
    }

    public MultiPoint createMultiPoint(Coordinate[] coordinates) {
        return this.createMultiPoint(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public MultiPoint createMultiPoint(CoordinateSequence coordinates) {
        if (coordinates == null) {
            return this.createMultiPoint(new Point[0]);
        }
        Point[] points = new Point[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            points[i] = this.createPoint(coordinates.getCoordinate(i));
        }
        return this.createMultiPoint(points);
    }

    public Polygon createPolygon(LinearRing shell, LinearRing[] holes) {
        return new Polygon(shell, holes, this);
    }

    public Geometry buildGeometry(Collection geomList) {
        boolean isCollection;
        Class<?> geomClass = null;
        boolean isHeterogeneous = false;
        boolean hasGeometryCollection = false;
        Iterator i = geomList.iterator();
        while (i.hasNext()) {
            Geometry geom = (Geometry)i.next();
            Class<?> partClass = geom.getClass();
            if (geomClass == null) {
                geomClass = partClass;
            }
            if (partClass != geomClass) {
                isHeterogeneous = true;
            }
            if (!(geom instanceof GeometryCollection)) continue;
            hasGeometryCollection = true;
        }
        if (geomClass == null) {
            return this.createGeometryCollection(null);
        }
        if (isHeterogeneous || hasGeometryCollection) {
            return this.createGeometryCollection(GeometryFactory.toGeometryArray(geomList));
        }
        Geometry geom0 = (Geometry)geomList.iterator().next();
        boolean bl = isCollection = geomList.size() > 1;
        if (isCollection) {
            if (geom0 instanceof Polygon) {
                return this.createMultiPolygon(GeometryFactory.toPolygonArray(geomList));
            }
            if (geom0 instanceof LineString) {
                return this.createMultiLineString(GeometryFactory.toLineStringArray(geomList));
            }
            if (geom0 instanceof Point) {
                return this.createMultiPoint(GeometryFactory.toPointArray(geomList));
            }
            Assert.shouldNeverReachHere("Unhandled class: " + geom0.getClass().getName());
        }
        return geom0;
    }

    public LineString createLineString(Coordinate[] coordinates) {
        return this.createLineString(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public LineString createLineString(CoordinateSequence coordinates) {
        return new LineString(coordinates, this);
    }

    public Geometry createGeometry(Geometry g) {
        GeometryEditor editor = new GeometryEditor(this);
        return editor.edit(g, new GeometryEditor.CoordinateOperation(){

            public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
                return coordinates;
            }
        });
    }

    public int getSRID() {
        return this.SRID;
    }

    public CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }
}

