/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags.read;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.encog.parse.PeekableInputStream;
import org.encog.parse.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadTags {
    public static final int CHAR_BULLET = 149;
    public static final int CHAR_TRADEMARK = 129;
    public static final int MAX_LENGTH = 10000;
    private static Map<String, Character> charMap;
    private final PeekableInputStream source;
    private final Tag tag = new Tag();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String lockedEndTag;
    private String insertEndTag = null;

    public ReadTags(InputStream inputStream) {
        this.source = new PeekableInputStream(inputStream);
        if (charMap == null) {
            charMap = new HashMap<String, Character>();
            charMap.put("nbsp", Character.valueOf(' '));
            charMap.put("lt", Character.valueOf('<'));
            charMap.put("gt", Character.valueOf('>'));
            charMap.put("amp", Character.valueOf('&'));
            charMap.put("quot", Character.valueOf('\"'));
            charMap.put("bull", Character.valueOf('\u0095'));
            charMap.put("trade", Character.valueOf('\u0081'));
        }
    }

    protected void eatWhitespace() {
        while (Character.isWhitespace((char)this.source.peek())) {
            this.source.read();
        }
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean is(String string, boolean bl) {
        if (!this.getTag().getName().equals(string)) {
            return false;
        }
        if (bl) {
            return this.getTag().getType() == Tag.Type.BEGIN;
        }
        return this.getTag().getType() == Tag.Type.END;
    }

    protected String parseAttributeName() {
        this.eatWhitespace();
        if ("\"'".indexOf(this.source.peek()) == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            while (!Character.isWhitespace(this.source.peek()) && this.source.peek() != 61 && this.source.peek() != 62 && this.source.peek() != -1) {
                char c = this.parseSpecialCharacter();
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return this.parseString();
    }

    private char parseSpecialCharacter() {
        char c = (char)this.source.read();
        int n = 0;
        if (c == '&') {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            do {
                if ((n2 = this.source.peek(n++)) == 38 || n2 == 59 || Character.isWhitespace(n2)) continue;
                stringBuilder.append((char)n2);
            } while (n2 != 59 && n2 != -1 && !Character.isWhitespace(n2));
            String string = stringBuilder.toString().trim().toLowerCase();
            if (string.length() > 0) {
                if (string.charAt(0) == '#') {
                    try {
                        c = (char)Integer.parseInt(string.substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                } else if (charMap.containsKey(string)) {
                    c = charMap.get(string).charValue();
                } else {
                    n = 0;
                }
            } else {
                n = 0;
            }
        }
        while (n > 0) {
            this.read();
            --n;
        }
        return c;
    }

    protected String parseString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.eatWhitespace();
        if ("\"'".indexOf(this.source.peek()) != -1) {
            int n = this.source.read();
            while (this.source.peek() != n && this.source.peek() != -1 && stringBuilder.length() <= 10000) {
                char c = this.parseSpecialCharacter();
                if (c == '\r' || c == '\n') continue;
                stringBuilder.append(c);
            }
            if ("\"'".indexOf(this.source.peek()) != -1) {
                this.source.read();
            }
        } else {
            while (!Character.isWhitespace(this.source.peek()) && this.source.peek() != -1 && this.source.peek() != 62) {
                stringBuilder.append(this.parseSpecialCharacter());
            }
        }
        return stringBuilder.toString();
    }

    protected void parseTag() {
        this.tag.clear();
        this.insertEndTag = null;
        StringBuilder stringBuilder = new StringBuilder();
        this.source.read();
        if (this.source.peek("!--")) {
            int n;
            this.source.skip("!--".length());
            while (!this.source.peek("-->") && (n = this.source.read()) != -1) {
                stringBuilder.append((char)n);
            }
            this.source.skip("-->".length());
            this.tag.setType(Tag.Type.COMMENT);
            this.tag.setName(stringBuilder.toString());
            return;
        }
        if (this.source.peek("![CDATA[")) {
            int n;
            this.source.skip("![CDATA[".length());
            while (!this.source.peek("]]") && (n = this.source.read()) != -1) {
                stringBuilder.append((char)n);
            }
            this.source.skip("]]".length());
            this.tag.setType(Tag.Type.CDATA);
            this.tag.setName(stringBuilder.toString());
            return;
        }
        while (!(this.source.peek() == -1 || Character.isWhitespace((char)this.source.peek()) || this.source.peek() == 62 || stringBuilder.length() > 0 && this.source.peek() == 47)) {
            stringBuilder.append((char)this.source.read());
        }
        this.eatWhitespace();
        if (stringBuilder.charAt(0) == '/') {
            this.tag.setName(stringBuilder.substring(1).toString());
            this.tag.setType(Tag.Type.END);
        } else {
            this.tag.setName(stringBuilder.toString());
            this.tag.setType(Tag.Type.BEGIN);
        }
        while (this.source.peek() != 62 && this.source.peek() != -1) {
            String string = this.parseAttributeName();
            String string2 = null;
            if (string.equals("/")) {
                this.eatWhitespace();
                if (this.source.peek() == 62) {
                    this.insertEndTag = this.tag.getName();
                    break;
                }
            }
            this.eatWhitespace();
            if (this.source.peek() == 61) {
                this.source.read();
                string2 = this.parseString();
            }
            this.tag.setAttribute(string, string2);
        }
        this.source.read();
    }

    private boolean peekEndTag(String string) {
        int n = 0;
        while (this.source.peek(n) != -1 && Character.isWhitespace(this.source.peek(n))) {
            ++n;
        }
        if (this.source.peek(n) != 60) {
            return false;
        }
        ++n;
        while (this.source.peek(n) != -1 && Character.isWhitespace(this.source.peek(n))) {
            ++n;
        }
        if (this.source.peek(n) != 47) {
            return false;
        }
        ++n;
        while (this.source.peek(n) != -1 && Character.isWhitespace(this.source.peek(n))) {
            ++n;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.toLowerCase(this.source.peek(n)) != Character.toLowerCase(string.charAt(i))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int read() {
        if (this.insertEndTag != null) {
            this.tag.clear();
            this.tag.setName(this.insertEndTag);
            this.tag.setType(Tag.Type.END);
            this.insertEndTag = null;
            return 0;
        }
        if (this.lockedEndTag != null) {
            if (this.peekEndTag(this.lockedEndTag)) {
                this.lockedEndTag = null;
            } else {
                return this.source.read();
            }
        }
        if (this.source.peek() == 60) {
            this.parseTag();
            if (this.tag.getType() == Tag.Type.BEGIN && (this.tag.getName().equalsIgnoreCase("script") || this.tag.getName().equalsIgnoreCase("style"))) {
                this.lockedEndTag = this.tag.getName().toLowerCase();
            }
            return 0;
        }
        if (this.source.peek() == 38) {
            return this.parseSpecialCharacter();
        }
        return this.source.read();
    }

    public boolean readToTag() {
        int n;
        while ((n = this.read()) != -1) {
            if (n != 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ReadTags: currentTag=");
        if (this.tag != null) {
            stringBuilder.append(this.tag.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

