/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.target;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.normalize.DataNormalization;
import org.encog.normalize.NormalizationError;
import org.encog.normalize.target.NormalizationStorage;
import org.encog.persist.annotations.EGIgnore;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class NormalizationStorageCSV
implements NormalizationStorage {
    private File outputFile;
    @EGIgnore
    private transient PrintWriter output;
    private CSVFormat format;

    public NormalizationStorageCSV(CSVFormat cSVFormat, File file) {
        this.format = cSVFormat;
        this.outputFile = file;
    }

    public NormalizationStorageCSV() {
        this.format = CSVFormat.EG_FORMAT;
    }

    public NormalizationStorageCSV(File file) {
        this.format = CSVFormat.ENGLISH;
        this.outputFile = file;
    }

    public void close() {
        this.output.close();
    }

    public void open(DataNormalization dataNormalization) {
        try {
            FileWriter fileWriter = new FileWriter(this.outputFile);
            this.output = new PrintWriter(fileWriter);
        }
        catch (IOException iOException) {
            throw new NormalizationError(iOException);
        }
    }

    public void write(double[] dArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        NumberList.toList(this.format, stringBuilder, dArray);
        this.output.println(stringBuilder.toString());
    }
}

