/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.output;

import org.encog.normalize.input.InputField;
import org.encog.normalize.output.BasicOutputField;
import org.encog.normalize.output.RequireTwoPass;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGReference;

public class OutputFieldRangeMapped
extends BasicOutputField
implements RequireTwoPass {
    @EGReference
    private InputField field;
    @EGAttribute
    private double low;
    @EGAttribute
    private double high;

    public static double calculate(double d, double d2, double d3, double d4, double d5) {
        return (d - d2) / (d3 - d2) * (d4 - d5) + d5;
    }

    public OutputFieldRangeMapped() {
    }

    public OutputFieldRangeMapped(InputField inputField, double d, double d2) {
        this.field = inputField;
        this.low = d;
        this.high = d2;
    }

    public double calculate(int n) {
        return (this.field.getCurrentValue() - this.field.getMin()) / (this.field.getMax() - this.field.getMin()) * (this.high - this.low) + this.low;
    }

    public InputField getField() {
        return this.field;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public int getSubfieldCount() {
        return 1;
    }

    public void rowInit() {
    }

    public double convertBack(double d) {
        double d2 = ((this.field.getMin() - this.field.getMax()) * d - this.high * this.field.getMin() + this.field.getMax() * this.low) / (this.low - this.high);
        return d2;
    }
}

