/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.strategy.end.EndTrainingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopTrainingStrategy
implements EndTrainingStrategy {
    public static final double DEFAULT_MIN_IMPROVEMENT = 1.0E-7;
    public static final int DEFAULT_TOLERATE_CYCLES = 100;
    private Train train;
    private boolean shouldStop;
    private boolean ready;
    private double lastError;
    private double bestError;
    private final double minImprovement;
    private final int toleratedCycles;
    private int badCycles;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public StopTrainingStrategy() {
        this(1.0E-7, 100);
    }

    public StopTrainingStrategy(double d, int n) {
        this.minImprovement = d;
        this.toleratedCycles = n;
        this.badCycles = 0;
        this.bestError = Double.MAX_VALUE;
    }

    public void init(Train train) {
        this.train = train;
        this.shouldStop = false;
        this.ready = false;
    }

    public void postIteration() {
        if (this.ready) {
            if (this.bestError - this.train.getError() < this.minImprovement) {
                ++this.badCycles;
                if (this.badCycles > this.toleratedCycles) {
                    this.shouldStop = true;
                }
            } else {
                this.badCycles = 0;
            }
        } else {
            this.ready = true;
        }
        this.lastError = this.train.getError();
        this.bestError = Math.min(this.lastError, this.bestError);
    }

    public void preIteration() {
    }

    public boolean shouldStop() {
        return this.shouldStop;
    }
}

