/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.layers;

import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.rbf.RadialBasisFunction;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.RadialBasisFunctionLayerPersistor;

public class RadialBasisFunctionLayer
extends BasicLayer {
    private static final long serialVersionUID = 2779781041654829282L;
    private RadialBasisFunction[] radialBasisFunction;

    public RadialBasisFunctionLayer() {
        this(1);
    }

    public RadialBasisFunctionLayer(int n) {
        super(new ActivationLinear(), false, n);
        this.radialBasisFunction = new RadialBasisFunction[n];
    }

    public NeuralData compute(NeuralData neuralData) {
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.getNeuronCount());
        for (int i = 0; i < this.getNeuronCount(); ++i) {
            if (this.radialBasisFunction[i] == null) {
                throw new NeuralNetworkError("Error, must define radial functions for each neuron");
            }
            RadialBasisFunction radialBasisFunction = this.radialBasisFunction[i];
            if (neuralData.getData().length != radialBasisFunction.getDimensions()) {
                throw new NeuralNetworkError("Inputs must equal the number of dimensions.");
            }
            basicNeuralData.setData(i, radialBasisFunction.calculate(neuralData.getData()));
        }
        return basicNeuralData;
    }

    public Persistor createPersistor() {
        return new RadialBasisFunctionLayerPersistor();
    }

    public RadialBasisFunction[] getRadialBasisFunction() {
        return this.radialBasisFunction;
    }

    public void randomizeRBFCentersAndWidths(int n, double d, double d2, RBFEnum rBFEnum) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = RangeRandomizer.randomize(d, d2);
        }
        for (n2 = 0; n2 < this.getNeuronCount(); ++n2) {
            this.setRBFFunction(n2, rBFEnum, dArray, RangeRandomizer.randomize(d, d2));
        }
    }

    public void setRadialBasisFunction(RadialBasisFunction[] radialBasisFunctionArray) {
        this.radialBasisFunction = radialBasisFunctionArray;
    }

    public void setRBFCentersAndWidths(double[][] dArray, double[] dArray2, RBFEnum rBFEnum) {
        for (int i = 0; i < this.getNeuronCount(); ++i) {
            this.setRBFFunction(i, rBFEnum, dArray[i], dArray2[i]);
        }
    }

    public void setRBFCentersAndWidthsEqualSpacing(double d, double d2, RBFEnum rBFEnum, int n, double d3, boolean bl) {
        int n2 = this.getNeuronCount();
        double d4 = Math.abs(d2 - d);
        int n3 = (int)Math.pow(n2, 1.0 / (double)n);
        if ((double)n3 != Math.pow(n2, 1.0 / (double)n)) {
            throw new NeuralNetworkError("Total number of RBF neurons must be some integer to the power of 'dimensions'.");
        }
        double d5 = 2.5 * d3;
        double[][] dArrayArray = new double[n2][];
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            int n4;
            dArrayArray[i] = new double[n];
            int n5 = n3;
            int n6 = i;
            for (n4 = n; n4 > 0; --n4) {
                dArrayArray[i][n4 - 1] = (double)((int)((double)n6 / Math.pow(n5, n4 - 1))) * (d4 / (double)(n5 - 1)) + d;
                n6 %= (int)Math.pow(n5, n4 - 1);
            }
            n4 = 0;
            for (int j = 0; j < dArrayArray[0].length; ++j) {
                if (dArrayArray[i][j] != 1.0 && dArrayArray[i][j] != 0.0) continue;
                n4 = 1;
            }
            dArray[i] = n4 != 0 && bl ? d5 : d3;
        }
        this.setRBFCentersAndWidths(dArrayArray, dArray, rBFEnum);
    }

    public void setRBFFunction(int n, RBFEnum rBFEnum, double[] dArray, double d) {
        if (rBFEnum == RBFEnum.Gaussian) {
            this.radialBasisFunction[n] = new GaussianFunction(0.5, dArray, d);
        } else if (rBFEnum == RBFEnum.Multiquadric) {
            this.radialBasisFunction[n] = new MultiquadricFunction(0.5, dArray, d);
        } else if (rBFEnum == RBFEnum.InverseMultiquadric) {
            this.radialBasisFunction[n] = new InverseMultiquadricFunction(0.5, dArray, d);
        }
    }
}

