/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.folded;

import java.util.Iterator;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.folded.FoldedDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldedIterator
implements Iterator<NeuralDataPair> {
    private final FoldedDataSet owner;
    private int currentIndex = 0;

    public FoldedIterator(FoldedDataSet foldedDataSet) {
        this.owner = foldedDataSet;
        this.currentIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.owner.getCurrentFoldSize();
    }

    @Override
    public NeuralDataPair next() {
        if (this.hasNext()) {
            NeuralDataPair neuralDataPair = BasicNeuralDataPair.createPair(this.owner.getInputSize(), this.owner.getIdealSize());
            this.owner.getRecord(this.currentIndex++, neuralDataPair);
            return neuralDataPair;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new NeuralDataError("Remove is not supported.");
    }
}

