/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.encog.neural.data.buffer.BufferedDataError;
import org.encog.neural.data.buffer.codec.DataSetCODEC;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.location.ResourcePersistence;
import org.encog.util.csv.CSVFormat;

public class ExcelCODEC
implements DataSetCODEC {
    private final File file;
    private ZipFile readZipFile;
    private ZipEntry entry;
    private ReadXML xmlIn;
    private int inputCount;
    private int idealCount;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private ByteArrayOutputStream buffer;
    private WriteXML xmlOut;
    private int row;

    public ExcelCODEC(File file) {
        this.file = file;
    }

    public ExcelCODEC(File file, int n, int n2) {
        this.file = file;
        this.inputCount = n;
        this.idealCount = n2;
    }

    public void close() {
        if (this.readZipFile != null) {
            try {
                this.readZipFile.close();
                this.readZipFile = null;
            }
            catch (IOException iOException) {
                throw new BufferedDataError(iOException);
            }
        }
        if (this.zos != null) {
            try {
                ZipEntry zipEntry = new ZipEntry("xl/worksheets/sheet1.xml");
                this.xmlOut.endTag();
                this.xmlOut.addAttribute("left", "0.7");
                this.xmlOut.addAttribute("right", "0.7");
                this.xmlOut.addAttribute("top", "0.75");
                this.xmlOut.addAttribute("bottom", "0.75");
                this.xmlOut.addAttribute("header", "0.3");
                this.xmlOut.addAttribute("footer", "0.3");
                this.xmlOut.beginTag("pageMargins");
                this.xmlOut.endTag();
                this.xmlOut.endTag();
                this.xmlOut.endDocument();
                byte[] byArray = this.buffer.toByteArray();
                zipEntry.setSize(byArray.length);
                zipEntry.setCompressedSize(-1L);
                zipEntry.setMethod(8);
                this.zos.putNextEntry(zipEntry);
                this.zos.write(byArray);
                this.zos.closeEntry();
                this.zos.close();
                this.zos = null;
            }
            catch (IOException iOException) {
                throw new BufferedDataError(iOException);
            }
        }
        if (this.fos != null) {
            try {
                this.fos.close();
                this.fos = null;
            }
            catch (IOException iOException) {
                throw new BufferedDataError(iOException);
            }
        }
    }

    public int getIdealSize() {
        return this.idealCount;
    }

    public int getInputSize() {
        return this.inputCount;
    }

    public void prepareRead() {
        try {
            Object object;
            this.readZipFile = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> enumeration = this.readZipFile.entries();
            this.entry = null;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!((ZipEntry)object).getName().equals("xl/worksheets/sheet1.xml")) continue;
                this.entry = object;
            }
            if (this.entry == null) {
                this.readZipFile.close();
                this.readZipFile = null;
                throw new BufferedDataError("Could not find worksheet.");
            }
            object = this.readZipFile.getInputStream(this.entry);
            this.xmlIn = new ReadXML((InputStream)object);
        }
        catch (ZipException zipException) {
            throw new BufferedDataError("Not a valid Excel file.");
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void prepareWrite(int n, int n2, int n3) {
        this.inputCount = n2;
        this.idealCount = n3;
        try {
            Object object;
            this.fos = new FileOutputStream(this.file);
            this.zos = new ZipOutputStream(this.fos);
            ResourcePersistence resourcePersistence = new ResourcePersistence("org/encog/data/blank.xlsx");
            InputStream inputStream = resourcePersistence.createInputStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while (zipInputStream.available() > 0) {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null || "xl/worksheets/sheet1.xml".equals(zipEntry.getName())) continue;
                object = new ZipEntry(zipEntry);
                ((ZipEntry)object).setCompressedSize(-1L);
                this.zos.putNextEntry((ZipEntry)object);
                byte[] byArray = new byte[(int)zipEntry.getSize()];
                zipInputStream.read(byArray);
                this.zos.write(byArray);
                this.zos.closeEntry();
            }
            zipInputStream.close();
            this.buffer = new ByteArrayOutputStream();
            this.xmlOut = new WriteXML(this.buffer);
            this.xmlOut.beginDocument();
            this.xmlOut.addAttribute("xmlns", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            this.xmlOut.addAttribute("xmlns:r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            this.xmlOut.beginTag("worksheet");
            object = new StringBuilder();
            ((StringBuilder)object).append(this.toColumn(this.inputCount + this.idealCount));
            ((StringBuilder)object).append("" + n);
            this.xmlOut.addAttribute("ref", "A1:" + ((StringBuilder)object).toString());
            this.xmlOut.beginTag("dimension");
            this.xmlOut.endTag();
            this.xmlOut.beginTag("sheetViews");
            this.xmlOut.addAttribute("tabSelected", "1");
            this.xmlOut.addAttribute("workbookViewId", "0");
            this.xmlOut.beginTag("sheetView");
            this.xmlOut.endTag();
            this.xmlOut.endTag();
            this.xmlOut.addAttribute("defaultRowHeight", "15");
            this.xmlOut.beginTag("sheetFormatPtr");
            this.xmlOut.endTag();
            this.row = 1;
            this.xmlOut.beginTag("sheetData");
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public boolean read(double[] dArray, double[] dArray2) {
        int n;
        while ((n = this.xmlIn.read()) != -1) {
            if (n != 0 || !this.xmlIn.is("row", true)) continue;
            this.readRow(this.xmlIn, dArray, dArray2);
            return true;
        }
        return false;
    }

    private void readRow(ReadXML readXML, double[] dArray, double[] dArray2) {
        int n;
        int n2 = 0;
        while ((n = this.xmlIn.read()) != -1) {
            if (n != 0) continue;
            if (this.xmlIn.is("v", true)) {
                String string = this.xmlIn.readTextToTag();
                double d = CSVFormat.ENGLISH.parse(string);
                if (n2 < dArray.length) {
                    dArray[n2] = d;
                } else {
                    dArray2[n2 - dArray.length] = d;
                }
                ++n2;
                continue;
            }
            if (!this.xmlIn.is("row", false)) continue;
            break;
        }
    }

    private String toColumn(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n / 26;
        int n3 = n % 26;
        if (n2 > 0) {
            stringBuilder.append((char)(65 + (n2 - 1)));
            stringBuilder.append((char)(65 + (n3 - 1)));
        } else {
            stringBuilder.append((char)(65 + (n3 - 1)));
        }
        return stringBuilder.toString();
    }

    public void write(double[] dArray, double[] dArray2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("1");
        stringBuilder.append(":");
        stringBuilder.append(this.inputCount + this.idealCount);
        this.xmlOut.addAttribute("spans", stringBuilder.toString());
        this.xmlOut.addAttribute("r", "" + this.row++);
        this.xmlOut.beginTag("row");
        int n2 = 0;
        for (n = 0; n < this.inputCount; ++n) {
            this.xmlOut.addAttribute("r", this.toColumn(n2++));
            this.xmlOut.beginTag("c");
            this.xmlOut.beginTag("v");
            this.xmlOut.addText(CSVFormat.EG_FORMAT.format(dArray[n], 10));
            this.xmlOut.endTag();
            this.xmlOut.endTag();
        }
        for (n = 0; n < this.idealCount; ++n) {
            this.xmlOut.addAttribute("r", this.toColumn(n2++));
            this.xmlOut.beginTag("c");
            this.xmlOut.beginTag("v");
            this.xmlOut.addText(CSVFormat.EG_FORMAT.format(dArray2[n], 10));
            this.xmlOut.endTag();
            this.xmlOut.endTag();
        }
        this.xmlOut.endTag();
    }
}

