/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiPolarUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static double bipolar2double(boolean bl) {
        if (bl) {
            return 1.0;
        }
        return -1.0;
    }

    public static double[] bipolar2double(boolean[] blArray) {
        double[] dArray = new double[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            dArray[i] = BiPolarUtil.bipolar2double(blArray[i]);
        }
        return dArray;
    }

    public static double[][] bipolar2double(boolean[][] blArray) {
        double[][] dArray = new double[blArray.length][blArray[0].length];
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[0].length; ++j) {
                dArray[i][j] = BiPolarUtil.bipolar2double(blArray[i][j]);
            }
        }
        return dArray;
    }

    public static boolean double2bipolar(double d) {
        return d > 0.0;
    }

    public static boolean[] double2bipolar(double[] dArray) {
        boolean[] blArray = new boolean[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            blArray[i] = BiPolarUtil.double2bipolar(dArray[i]);
        }
        return blArray;
    }

    public static boolean[][] double2bipolar(double[][] dArray) {
        boolean[][] blArray = new boolean[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                blArray[i][j] = BiPolarUtil.double2bipolar(dArray[i][j]);
            }
        }
        return blArray;
    }

    public static double normalizeBinary(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double toBinary(double d) {
        return (d + 1.0) / 2.0;
    }

    public static double toBiPolar(double d) {
        return 2.0 * BiPolarUtil.normalizeBinary(d) - 1.0;
    }

    public static double toNormalizedBinary(double d) {
        return BiPolarUtil.normalizeBinary(BiPolarUtil.toBinary(d));
    }

    private BiPolarUtil() {
    }
}

