/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g.lowmem;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KArrayGrabber", author="Peter Krause", description="This component selects data values from arrays representinga standard year.", version="1.0_0", date="2011-05-30")
public class ArrayGrabber
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [m | d | h]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="extraTerrRadiationArray")
    public Attribute.DoubleArray extRadArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actExtraTerrRadiation")
    public Attribute.Double actExtRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="actSlopeAscpectCorrectionFactor")
    public Attribute.Double actSlAsCf;

    public void init() throws Attribute.Entity.NoSuchAttributeException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        int monthCount = this.time.get(2);
        int dayCount = this.time.get(6) - 1;
        int hourCount = this.time.get(11) + 24 * dayCount;
        double in_extRad = JAMS.getMissingDataValue();
        double in_scf = JAMS.getMissingDataValue();
        if (this.tempRes.getValue().equals("m")) {
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[monthCount];
            }
        } else if (this.tempRes.getValue().equals("d")) {
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[dayCount];
            }
        } else if (this.tempRes.getValue().equals("h") && this.extRadArray != null) {
            in_extRad = this.extRadArray.getValue()[hourCount];
        }
        this.actSlAsCf.setValue(in_scf);
        this.actExtRad.setValue(in_extRad);
    }

    public void cleanup() {
    }
}

