/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitSoilWaterStates", author="Peter Krause", description="Defines soil water attributes for each HRU")
public class InitSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="field capacity adaptation factor")
    public Attribute.Double FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="infiltration capacity adaptation", defaultValue="1.0")
    public Attribute.Double maxInfAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="infiltration capacity adaptation", defaultValue="Infinity")
    public Attribute.Double maxInf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU statevar rooting depth")
    public Attribute.Double rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum MPS")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum percolation rate")
    public Attribute.Double maxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var actual MPS")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative start content")
    public Attribute.Double initMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum percolation adaptation factor")
    public Attribute.Double maxPercAdaptation;

    public void init() {
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        double rootDepth = this.rootDepth.getValue();
        double mxMPS = 0.0;
        String aNameFC = "fc_";
        int d = 0;
        while ((double)d < rootDepth) {
            int count = d + 1;
            String mpsDesc = aNameFC + count;
            double mpsVal = entity.getDouble(mpsDesc);
            mxMPS += mpsVal;
            ++d;
        }
        mxMPS *= this.area.getValue();
        this.maxMPS.setValue(mxMPS *= this.FCAdaptation.getValue());
        this.maxInf.setValue(this.maxInf.getValue() * this.maxInfAdaptation.getValue());
        this.actMPS.setValue(this.initMPS.getValue() * mxMPS);
        double mxPerc = entity.getDouble("mxPerc") * this.maxPercAdaptation.getValue() * this.area.getValue();
        this.maxPerc.setValue(mxPerc);
    }

    public void cleanup() {
    }
}

