/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Converts cumulative runoff volumes into flows")
public class FlowAggregator3
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="catchment area")
    public Attribute.Double cArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the input variables to convert")
    public Attribute.Double[] inVars;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the converted output variables")
    public Attribute.Double[] outVars;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the actual time step")
    public Attribute.Calendar timeStep;

    public void init() {
    }

    public void run() {
        long days = 1L;
        if (this.timeStep != null) {
            days = this.timeStep.getActualMaximum(5);
        }
        for (int i = 0; i < this.inVars.length; ++i) {
            this.outVars[i].setValue(this.inVars[i].getValue() * this.cArea.getValue() / (double)(86400000L * days));
        }
    }

    public void cleanup() {
    }
}

