/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewDatatypeDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -1930736056916611522L;
    private JTextField nameField;
    private JTextField stringLengthField;
    private JComboBox parentChoice;
    private JComboBox classChoice;
    private JComboBox sizeChoice;
    private JComboBox endianChoice;
    private JCheckBox checkUnsigned;
    private boolean isH5;
    private List groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;

    public NewDatatypeDialog(JFrame owner, Group pGroup, List objs) {
        super(owner, "New Datatype...", true);
        this.fileFormat = pGroup.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = pGroup.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.parentChoice = new JComboBox();
        this.groupList = new Vector(objs.size());
        Object obj2 = null;
        for (Object obj2 : objs) {
            if (!(obj2 instanceof Group)) continue;
            Group g = (Group)obj2;
            this.groupList.add(obj2);
            if (g.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(g.getPath() + g.getName() + "/");
        }
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 600 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 200 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout(5, 5));
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        tmpP.add(new JLabel("Datatype name: "));
        tmpP.add(new JLabel("Parent group: "));
        namePanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField();
        tmpP.add(this.nameField);
        tmpP.add(this.parentChoice);
        namePanel.add((Component)tmpP, "Center");
        contentPane.add((Component)namePanel, "North");
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new GridLayout(2, 4, 15, 3));
        TitledBorder border = new TitledBorder("Datatype");
        border.setTitleColor(Color.blue);
        typePanel.setBorder(border);
        this.stringLengthField = new JTextField("String length");
        this.stringLengthField.setEnabled(false);
        this.endianChoice = new JComboBox();
        this.classChoice = new JComboBox();
        this.sizeChoice = new JComboBox();
        this.endianChoice.setEnabled(this.isH5);
        this.classChoice.addItem("INTEGER");
        this.classChoice.addItem("FLOAT");
        this.classChoice.addItem("CHAR");
        if (this.isH5) {
            this.classChoice.addItem("STRING");
            this.classChoice.addItem("REFERENCE");
            this.sizeChoice.addItem("NATIVE");
            this.endianChoice.addItem("NATIVE");
            this.endianChoice.addItem("LITTLE ENDIAN");
            this.endianChoice.addItem("BIG ENDIAN");
        } else {
            this.sizeChoice.addItem("DEFAULT");
            this.endianChoice.addItem("DEFAULT");
            typePanel.add(new JLabel());
        }
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("32");
        this.sizeChoice.addItem("64");
        typePanel.add(new JLabel("Datatype class"));
        typePanel.add(new JLabel("Size (bits)"));
        typePanel.add(new JLabel("Byte ordering"));
        this.checkUnsigned = new JCheckBox("Unsigned");
        typePanel.add(this.checkUnsigned);
        typePanel.add(this.classChoice);
        typePanel.add(this.sizeChoice);
        typePanel.add(this.endianChoice);
        typePanel.add(this.stringLengthField);
        contentPane.add((Component)typePanel, "Center");
        this.classChoice.addItemListener(this);
        this.sizeChoice.addItemListener(this);
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 100;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.newObject = this.createDatatype();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (cmd.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.classChoice)) {
            int idx = this.classChoice.getSelectedIndex();
            this.sizeChoice.setSelectedIndex(0);
            this.endianChoice.setSelectedIndex(0);
            this.stringLengthField.setEnabled(false);
            if (idx == 0) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
                if (this.sizeChoice.getItemCount() == 3) {
                    this.sizeChoice.removeItem("32");
                    this.sizeChoice.removeItem("64");
                    this.sizeChoice.addItem("8");
                    this.sizeChoice.addItem("16");
                    this.sizeChoice.addItem("32");
                    this.sizeChoice.addItem("64");
                }
            } else if (idx == 1) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(false);
                if (this.sizeChoice.getItemCount() == 5) {
                    this.sizeChoice.removeItem("16");
                    this.sizeChoice.removeItem("8");
                }
            } else if (idx == 2) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
            } else if (idx == 3) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(true);
                this.stringLengthField.setText("String length");
            } else if (idx == 4) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(false);
            }
        } else if (source.equals(this.sizeChoice) && this.classChoice.getSelectedIndex() == 0) {
            this.checkUnsigned.setEnabled(true);
        }
    }

    private HObject createDatatype() {
        String name = null;
        Group pgroup = null;
        int tclass = -1;
        int tsize = -1;
        int torder = -1;
        int tsign = -1;
        name = this.nameField.getText().trim();
        if (name == null || name.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Datatype name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Datatype name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        int idx = this.classChoice.getSelectedIndex();
        if (idx == 0) {
            tclass = 0;
            if (this.checkUnsigned.isSelected()) {
                tsign = 0;
            }
        } else if (idx == 1) {
            tclass = 1;
        } else if (idx == 2) {
            tclass = 2;
            if (this.checkUnsigned.isSelected()) {
                tsign = 0;
            }
        } else if (idx == 3) {
            tclass = 3;
        } else if (idx == 4) {
            tclass = 7;
        }
        idx = this.sizeChoice.getSelectedIndex();
        if (tclass == 3) {
            int stringLength = 0;
            try {
                stringLength = Integer.parseInt(this.stringLengthField.getText());
            }
            catch (NumberFormatException ex) {
                stringLength = -1;
            }
            if (stringLength <= 0) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid string length: " + this.stringLengthField.getText(), this.getTitle(), 0);
                return null;
            }
            tsize = stringLength;
        } else {
            tsize = tclass == 7 ? 1 : (idx == 0 ? -1 : (tclass == 1 ? idx * 4 : 1 << idx - 1));
        }
        if (tsize == 8 && !this.isH5 && tclass == 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "HDF4 does not support 64-bit integer.", this.getTitle(), 0);
            return null;
        }
        idx = this.endianChoice.getSelectedIndex();
        torder = idx == 0 ? -1 : (idx == 1 ? 0 : 1);
        Datatype obj = null;
        try {
            Datatype datatype;
            String fullPath = "/";
            fullPath = pgroup.isRoot() ? fullPath + name : pgroup.getPath() + "/" + pgroup.getName() + "/" + name;
            obj = datatype = this.fileFormat.createDatatype(tclass, tsize, torder, tsign, fullPath);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return null;
        }
        return obj;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

