/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewProperties;

public class FileConversionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2645021913986116744L;
    private String fileTypeFrom;
    private String fileTypeTo;
    private JTextField srcFileField;
    private JTextField dstFileField;
    private boolean isConverted;
    private boolean isConvertedFromImage;
    private String convertedFile;
    private String toFileExtension;
    private List fileList;
    private String currentDir;
    private final Toolkit toolkit;

    public FileConversionDialog(Frame owner, String typeFrom, String typeTo, String dir, List openFiles) {
        super(owner, "Convert File...", true);
        this.fileTypeFrom = typeFrom;
        this.fileTypeTo = typeTo;
        this.isConverted = false;
        this.isConvertedFromImage = false;
        this.fileList = openFiles;
        this.toFileExtension = "";
        this.currentDir = dir;
        this.toolkit = Toolkit.getDefaultToolkit();
        String fromName = "Source";
        if (this.fileTypeTo.equals("HDF5")) {
            this.toFileExtension = ".h5";
            this.setTitle("Convert Image to HDF5 ...");
            fromName = "IMAGE";
            this.isConvertedFromImage = true;
        } else if (this.fileTypeTo.equals("HDF4")) {
            this.toFileExtension = ".hdf";
            this.setTitle("Convert Image to HDF4 ...");
            fromName = "IMAGE";
            this.isConvertedFromImage = true;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 450 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 120 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(5, 5));
        JPanel p0 = new JPanel();
        p0.setLayout(new GridLayout(2, 1, 5, 5));
        p0.add(new JLabel(fromName + " File: "));
        p0.add(new JLabel("HDF File: "));
        p.add((Component)p0, "West");
        p0 = new JPanel();
        p0.setLayout(new GridLayout(2, 1, 5, 5));
        this.srcFileField = new JTextField();
        p0.add(this.srcFileField);
        this.dstFileField = new JTextField();
        p0.add(this.dstFileField);
        p.add((Component)p0, "Center");
        p0 = new JPanel();
        p0.setLayout(new GridLayout(2, 1, 5, 5));
        JButton jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse source file");
        jButton.addActionListener(this);
        p0.add(jButton);
        jButton = new JButton("Browse...");
        jButton.setActionCommand("Browse target file");
        jButton.addActionListener(this);
        p0.add(jButton);
        p.add((Component)p0, "East");
        contentPane.add((Component)p, "Center");
        JButton okButton = new JButton("   Ok   ");
        okButton.setMnemonic(79);
        okButton.setActionCommand("Ok");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        p = new JPanel();
        p.add(okButton);
        p.add(cancelButton);
        contentPane.add((Component)p, "South");
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.isConverted = this.convert();
            if (this.isConverted) {
                this.dispose();
            }
        } else if (cmd.equals("Cancel")) {
            this.isConverted = false;
            this.convertedFile = null;
            this.dispose();
        } else if (cmd.equals("Browse source file")) {
            int returnVal;
            JFileChooser fchooser = new JFileChooser(this.currentDir);
            if (this.isConvertedFromImage) {
                fchooser.setFileFilter(DefaultFileFilter.getImageFileFilter());
            }
            if ((returnVal = fchooser.showOpenDialog(this)) != 0) {
                return;
            }
            File choosedFile = fchooser.getSelectedFile();
            if (choosedFile == null) {
                return;
            }
            String fname = choosedFile.getAbsolutePath();
            if (fname == null) {
                return;
            }
            this.currentDir = choosedFile.getParent();
            this.srcFileField.setText(fname);
            this.dstFileField.setText(fname + this.toFileExtension);
        } else if (cmd.equals("Browse target file")) {
            JFileChooser fchooser = new JFileChooser();
            int returnVal = fchooser.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            File choosedFile = fchooser.getSelectedFile();
            if (choosedFile == null) {
                return;
            }
            String fname = choosedFile.getAbsolutePath();
            if (fname == null) {
                return;
            }
            this.dstFileField.setText(fname);
        }
    }

    private boolean convert() {
        boolean converted = false;
        String srcFile = this.srcFileField.getText();
        String dstFile = this.dstFileField.getText();
        if (srcFile == null || dstFile == null) {
            return false;
        }
        srcFile = srcFile.trim();
        dstFile = dstFile.trim();
        if (srcFile == null || srcFile.length() <= 0 || dstFile == null || dstFile.length() <= 0) {
            return false;
        }
        File f = new File(srcFile);
        if (!f.exists()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file does not exist.", this.getTitle(), 0);
            return false;
        }
        if (f.isDirectory()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file is a directory.", this.getTitle(), 0);
            return false;
        }
        String srcPath = f.getParent();
        f = new File(dstFile);
        File pfile = f.getParentFile();
        if (pfile == null) {
            dstFile = srcPath + File.separator + dstFile;
            f = new File(dstFile);
        } else if (!pfile.exists()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Destination file path does not exist at\n" + pfile.getPath(), this.getTitle(), 0);
            return false;
        }
        if (this.fileList != null) {
            FileFormat theFile2 = null;
            for (FileFormat theFile2 : this.fileList) {
                if (!theFile2.getFilePath().equals(dstFile)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "The destination file is being used.", this.getTitle(), 0);
                return false;
            }
        }
        int newFileFlag = -1;
        if (f.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "Destination file exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return false;
        }
        try {
            Tools.convertImageToHDF(srcFile, dstFile, this.fileTypeFrom, this.fileTypeTo);
            this.convertedFile = dstFile;
            converted = true;
        }
        catch (Exception ex) {
            this.convertedFile = null;
            converted = false;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return false;
        }
        return converted;
    }

    public boolean isFileConverted() {
        return this.isConverted;
    }

    public String getConvertedFile() {
        return this.convertedFile;
    }
}

