/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui.tree;

import jams.server.client.JobController;
import jams.server.client.gui.tree.JAMSServerTree;
import jams.server.client.gui.tree.JAMSServerTreeNodes;
import jams.server.entities.Job;
import jams.server.entities.JobState;
import jams.server.entities.Jobs;
import jams.server.entities.User;
import jams.server.entities.WorkspaceFileAssociation;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class JobsTree
extends JAMSServerTree {
    JobController c;

    private DefaultMutableTreeNode createJobNode(Job job, JobState state) {
        JAMSServerTreeNodes.SortedMutableTreeNode top = JAMSServerTreeNodes.getNode(job, state);
        for (WorkspaceFileAssociation wfa : job.getWorkspace().getFiles()) {
            this.attachWFAtoTree(wfa, top);
        }
        return top;
    }

    public void updateNode(Job job) {
        DefaultMutableTreeNode newNode = this.createJobNode(job, null);
        JAMSServerTreeNodes.JobNode oldNode = this.findNode(this.getRoot(), job);
        if (oldNode == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)oldNode.getParent();
        int index = parent.getIndex(oldNode);
        oldNode.removeFromParent();
        parent.insert(newNode, index);
    }

    public Job getSelectedJob() {
        if (!this.isShowing()) {
            return null;
        }
        JAMSServerTreeNodes.SortedMutableTreeNode o = this.getSelectedNode();
        if (o != null && o instanceof JAMSServerTreeNodes.JobNode) {
            return ((JAMSServerTreeNodes.JobNode)o).getJob();
        }
        return null;
    }

    public JAMSServerTreeNodes.JobNode findNode(JAMSServerTreeNodes.SortedMutableTreeNode root, Job object) {
        Object o = root.getUserObject();
        if (o.equals(object)) {
            return (JAMSServerTreeNodes.JobNode)root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            JAMSServerTreeNodes.SortedMutableTreeNode child = (JAMSServerTreeNodes.SortedMutableTreeNode)root.getChildAt(i);
            JAMSServerTreeNodes.JobNode result = this.findNode(child, object);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void generateModel(User user, Jobs jobs, JobController c) {
        JAMSServerTreeNodes.SortedMutableTreeNode root = JAMSServerTreeNodes.getNode(user);
        this.c = c;
        for (Job job : jobs.getJobs()) {
            JobState state = null;
            if (job.getPID() > 0) {
                state = c.getState(job);
            }
            root.add(this.createJobNode(job, state));
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
    }
}

