/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui.tree;

import jams.server.entities.Job;
import jams.server.entities.JobState;
import jams.server.entities.User;
import jams.server.entities.Workspace;
import jams.server.entities.WorkspaceFileAssociation;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;

public class JAMSServerTreeNodes {
    public static SortedMutableTreeNode getNode(User user) {
        return new UserNode(user);
    }

    public static SortedMutableTreeNode getNode(Workspace ws) {
        return new WorkspaceNode(ws);
    }

    public static SortedMutableTreeNode getNode(WorkspaceFileAssociation wfa) {
        return new WFANode(wfa);
    }

    public static SortedMutableTreeNode getNode(Job job, JobState state) {
        return new JobNode(job, state);
    }

    public static SortedMutableTreeNode getNode(String string) {
        return new SortedMutableTreeNode(string);
    }

    public static class WFANode
    extends SortedMutableTreeNode {
        WorkspaceFileAssociation wfa;
        String fileName;
        String[] subdirs;

        public WFANode(WorkspaceFileAssociation wfa) {
            super(wfa);
            this.wfa = wfa;
            String path = wfa.getPath().replace("\\\\", "\\");
            path = path.replace("//", "/");
            path = path.replaceAll("^/", "");
            path = path.replaceAll("^\\\\", "");
            this.subdirs = path.split("[/\\\\]");
            this.fileName = this.subdirs.length != 0 ? this.subdirs[this.subdirs.length - 1] : "";
        }

        public WorkspaceFileAssociation getWFA() {
            return this.wfa;
        }

        public String[] getSubdirs() {
            return this.subdirs;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String toString() {
            return this.fileName;
        }
    }

    public static class JobNode
    extends SortedMutableTreeNode {
        JobState state;

        public JobNode(Job job, JobState state) {
            super(job);
            this.state = state;
        }

        @Override
        public String toString() {
            Job job = this.getJob();
            String s = job.getWorkspace().getName() != null ? String.format("Job %05d - %s", job.getId(), job.getWorkspace().getName()) : String.format("Job %05d", job.getId());
            if (this.state != null) {
                s = s + String.format(" (%d%%)", Math.round(this.state.getProgress() * 100.0f));
            }
            return s;
        }

        public Job getJob() {
            return (Job)this.getUserObject();
        }

        @Override
        public int compareTo(SortedMutableTreeNode o) {
            if (o instanceof JobNode) {
                JobNode o1 = this;
                JobNode o2 = (JobNode)o;
                return o1.getJob().getId().compareTo(o2.getJob().getId());
            }
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }

    public static class WorkspaceNode
    extends SortedMutableTreeNode {
        public WorkspaceNode(Workspace ws) {
            super(ws);
        }

        public Workspace getWorkspace() {
            return (Workspace)this.userObject;
        }

        @Override
        public String toString() {
            Workspace ws = this.getWorkspace();
            if (ws.getName() != null) {
                return String.format("Workspace %05d - %s", ws.getId(), ws.getName());
            }
            return String.format("Workspace %05d", ws.getId());
        }

        @Override
        public int compareTo(SortedMutableTreeNode o) {
            if (o instanceof WorkspaceNode) {
                WorkspaceNode o1 = this;
                WorkspaceNode o2 = (WorkspaceNode)o;
                return o1.getWorkspace().getId().compareTo(o2.getWorkspace().getId());
            }
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }

    public static class UserNode
    extends SortedMutableTreeNode {
        private UserNode(User user) {
            super(user);
        }

        @Override
        public String toString() {
            return ((User)this.userObject).getName();
        }
    }

    public static class SortedMutableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<SortedMutableTreeNode> {
        protected Comparator nodeComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof SortedMutableTreeNode && o2 instanceof SortedMutableTreeNode) {
                    SortedMutableTreeNode s1 = (SortedMutableTreeNode)o1;
                    SortedMutableTreeNode s2 = (SortedMutableTreeNode)o2;
                    if (!s1.isLeaf() && s2.isLeaf()) {
                        return -1;
                    }
                    if (s1.isLeaf() && !s2.isLeaf()) {
                        return 1;
                    }
                    return s1.compareTo(s2);
                }
                return o1.toString().compareToIgnoreCase(o2.toString());
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        };

        public SortedMutableTreeNode(Object o) {
            super(o);
        }

        public void add(DefaultMutableTreeNode newChild) {
            super.add(newChild);
            Collections.sort(this.children, this.nodeComparator);
        }

        public void insert(DefaultMutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            Collections.sort(this.children, this.nodeComparator);
        }

        @Override
        public int compareTo(SortedMutableTreeNode o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }
}

