/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui.tree;

import jams.server.client.gui.tree.JAMSServerTreeNodes;
import jams.server.entities.WorkspaceFileAssociation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class JAMSServerTree
extends JTree {
    ImageIcon folderIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/folder.png"));
    ImageIcon workingIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/wait.png"));
    ImageIcon finishedIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/Ok.png"));
    ImageIcon userIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/user.png"));
    ImageIcon modelIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon16.png"));
    ImageIcon jarIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/jar.png"));
    ImageIcon inputIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/input.png"));
    ImageIcon outputIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/output.png"));
    ImageIcon executableIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/exeIcon.png"));
    ImageIcon configIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/Preferences16.png"));
    ImageIcon otherIcon = new ImageIcon(ClassLoader.getSystemResource("resources/images/help16.png"));

    public JAMSServerTree() {
        this.setCellRenderer(new WorkspaceCellRenderer());
    }

    protected void attachWFAtoTree(WorkspaceFileAssociation wfa, JAMSServerTreeNodes.SortedMutableTreeNode top) {
        JAMSServerTreeNodes.WFANode node = new JAMSServerTreeNodes.WFANode(wfa);
        JAMSServerTreeNodes.SortedMutableTreeNode currentNode = top;
        for (String dir : node.subdirs) {
            if (node.fileName.equals(dir)) {
                currentNode.add(JAMSServerTreeNodes.getNode(wfa));
                break;
            }
            Enumeration<TreeNode> enumeration = currentNode.children();
            boolean successful = false;
            while (enumeration.hasMoreElements()) {
                TreeNode o = enumeration.nextElement();
                if (!o.toString().equals(dir)) continue;
                currentNode = (JAMSServerTreeNodes.SortedMutableTreeNode)o;
                successful = true;
                break;
            }
            if (successful) continue;
            JAMSServerTreeNodes.SortedMutableTreeNode newNode = JAMSServerTreeNodes.getNode(dir);
            currentNode.add(newNode);
            currentNode = newNode;
        }
    }

    public JAMSServerTreeNodes.SortedMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object o = path.getLastPathComponent();
        if (JAMSServerTreeNodes.SortedMutableTreeNode.class.isAssignableFrom(o.getClass())) {
            return (JAMSServerTreeNodes.SortedMutableTreeNode)o;
        }
        return null;
    }

    public JAMSServerTreeNodes.SortedMutableTreeNode getRoot() {
        return (JAMSServerTreeNodes.SortedMutableTreeNode)this.getModel().getRoot();
    }

    public Object getUserObjectAtLocation(MouseEvent e) {
        TreePath p = this.getClosestPathForLocation(e.getX(), e.getY());
        if (p != null) {
            this.getSelectionModel().setSelectionPath(p);
        } else {
            this.getSelectionModel().clearSelection();
        }
        if (!(e.getComponent() instanceof JTree)) {
            return null;
        }
        if (p == null) {
            return null;
        }
        Object lastTreePathObject = p.getLastPathComponent();
        if (DefaultMutableTreeNode.class.isAssignableFrom(lastTreePathObject.getClass())) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastTreePathObject;
            return node.getUserObject();
        }
        return null;
    }

    class WorkspaceCellRenderer
    implements TreeCellRenderer {
        JPanel renderer = new JPanel();
        JLabel item = new JLabel(" ");
        DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
        Font defaultFont = new Font("Arial", 0, 10);
        Color backgroundSelectionColor = new Color(220, 220, 220);
        Color backgroundNonSelectionColor = this.defaultRenderer.getBackgroundNonSelectionColor();

        public WorkspaceCellRenderer() {
            this.renderer.setLayout(new BorderLayout());
            this.renderer.add((Component)this.item, "Center");
            this.item.setFont(this.defaultFont);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component returnValue = null;
            if (value != null && value instanceof DefaultMutableTreeNode) {
                if (selected) {
                    this.renderer.setBackground(this.backgroundSelectionColor);
                } else {
                    this.renderer.setBackground(this.backgroundNonSelectionColor);
                }
                this.renderer.setMinimumSize(new Dimension(300, 15));
                this.renderer.setPreferredSize(new Dimension(300, 20));
                this.renderer.setMaximumSize(new Dimension(300, 25));
                this.renderer.setEnabled(tree.isEnabled());
                this.renderer.setAlignmentX(0.0f);
                this.item.setAlignmentX(0.0f);
                this.item.setHorizontalAlignment(2);
                this.item.setText(value.toString());
                this.item.setIcon(JAMSServerTree.this.folderIcon);
                if (value instanceof JAMSServerTreeNodes.WFANode) {
                    this.renderer.setMinimumSize(new Dimension(300, 12));
                    this.renderer.setPreferredSize(new Dimension(300, 17));
                    this.renderer.setMaximumSize(new Dimension(300, 22));
                    JAMSServerTreeNodes.WFANode wfaNode = (JAMSServerTreeNodes.WFANode)value;
                    switch (wfaNode.getWFA().getRole()) {
                        case 0: {
                            this.item.setIcon(JAMSServerTree.this.inputIcon);
                            break;
                        }
                        case 1: {
                            this.item.setIcon(JAMSServerTree.this.outputIcon);
                            break;
                        }
                        case 5: {
                            this.item.setIcon(JAMSServerTree.this.jarIcon);
                            break;
                        }
                        case 6: {
                            this.item.setIcon(JAMSServerTree.this.jarIcon);
                            break;
                        }
                        case 3: {
                            this.item.setIcon(JAMSServerTree.this.configIcon);
                            break;
                        }
                        case 7: {
                            this.item.setIcon(JAMSServerTree.this.executableIcon);
                            break;
                        }
                        case 8: {
                            this.item.setIcon(JAMSServerTree.this.configIcon);
                            break;
                        }
                        case 2: {
                            this.item.setIcon(JAMSServerTree.this.modelIcon);
                            break;
                        }
                        default: {
                            this.item.setIcon(JAMSServerTree.this.otherIcon);
                        }
                    }
                }
                if (value instanceof JAMSServerTreeNodes.UserNode) {
                    this.renderer.setMinimumSize(new Dimension(300, 20));
                    this.renderer.setPreferredSize(new Dimension(300, 25));
                    this.renderer.setMaximumSize(new Dimension(300, 35));
                    this.item.setIcon(JAMSServerTree.this.userIcon);
                }
                if (value instanceof JAMSServerTreeNodes.WorkspaceNode) {
                    this.renderer.setMinimumSize(new Dimension(300, 12));
                    this.renderer.setPreferredSize(new Dimension(300, 17));
                    this.renderer.setMaximumSize(new Dimension(300, 22));
                    JAMSServerTreeNodes.WorkspaceNode wsNode = (JAMSServerTreeNodes.WorkspaceNode)value;
                    this.item.setText(wsNode.toString());
                    this.item.setIcon(JAMSServerTree.this.folderIcon);
                }
                if (value instanceof JAMSServerTreeNodes.JobNode) {
                    this.renderer.setMinimumSize(new Dimension(300, 12));
                    this.renderer.setPreferredSize(new Dimension(300, 17));
                    this.renderer.setMaximumSize(new Dimension(300, 22));
                    JAMSServerTreeNodes.JobNode jobNode = (JAMSServerTreeNodes.JobNode)value;
                    this.item.setText(jobNode.toString());
                    if (jobNode.getJob().getPID() > 0) {
                        this.item.setForeground(Color.GREEN.darker().darker());
                        this.item.setIcon(JAMSServerTree.this.workingIcon);
                    } else {
                        this.item.setForeground(Color.black);
                        this.item.setIcon(JAMSServerTree.this.finishedIcon);
                    }
                }
            }
            if ((returnValue = this.renderer) == null) {
                returnValue = this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return returnValue;
        }
    }
}

