/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client.gui;

import jams.ErrorCatchingRunnable;
import jams.JAMS;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.gui.tools.GUIState;
import jams.server.client.Controller;
import jams.server.client.FileController;
import jams.server.client.JobController;
import jams.server.client.UserController;
import jams.server.client.WorkspaceController;
import jams.server.client.gui.FilePropertiesDlg;
import jams.server.client.gui.JAMSCloudGraphicalController;
import jams.server.client.gui.UploadWorkspaceDlg;
import jams.server.client.gui.ViewStreamDlg;
import jams.server.client.gui.tree.JAMSServerTreeNodes;
import jams.server.client.gui.tree.JobsTree;
import jams.server.client.gui.tree.WorkspaceTree;
import jams.server.entities.Job;
import jams.server.entities.Jobs;
import jams.server.entities.User;
import jams.server.entities.Workspace;
import jams.server.entities.WorkspaceFileAssociation;
import jams.server.entities.Workspaces;
import jams.tools.LogTools;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.ws.rs.ProcessingException;

public class BrowseJAMSCloudDlg
extends JDialog {
    private static final Logger log = Logger.getLogger(BrowseJAMSCloudDlg.class.getName());
    final String infoLogFile = "info.log";
    final String errorLog = "error.log";
    private Window parent;
    Jobs jobs = null;
    JPanel mainPanel = null;
    JTabbedPane viewPane = new JTabbedPane();
    WorkspaceTree workspaceTree = new WorkspaceTree();
    JobsTree jobsTree = new JobsTree();
    JFileChooser jfc = new JFileChooser();
    JFileChooser wsChooser = new JFileChooser();
    JLabel wsNameLabel = new JLabel("name:");
    JTextField wsName = new JTextField(20);
    JLabel wsCreationDate = new JLabel("created:");
    JTextField wsCreation = new JTextField(10);
    JLabel wsSizeLabel = new JLabel("size:");
    JTextField wsSize = new JTextField(10);
    JLabel jobNameLabel = new JLabel("name:");
    JTextField jobName = new JTextField(20);
    JLabel jobCreationDate = new JLabel("created:");
    JTextField jobCreation = new JTextField(10);
    JLabel jobSizeLabel = new JLabel("size:");
    JTextField jobSize = new JTextField(10);
    JLabel statusLabel = new JLabel("status");
    JAMSCloudGraphicalController connector = null;
    boolean isConnected = false;
    LogTools.ObservableLogHandler observable = new LogTools.ObservableLogHandler(new Logger[]{Logger.getLogger(Controller.class.getName()), Logger.getLogger(FileController.class.getName()), Logger.getLogger(WorkspaceController.class.getName()), Logger.getLogger(JobController.class.getName()), Logger.getLogger(UserController.class.getName())});
    Action deleteJobAction = null;
    Action killJobAction = null;
    Action deleteWorkspaceAction = null;
    Action startWorkspaceAction = null;
    Action downloadWorkspaceAction = null;
    Action downloadFileAction = null;
    Action uploadWorkspaceAction = null;
    Action showFileProperties = null;
    Action updateJobAction = null;
    Action deleteAllJobsAction = null;
    Action deleteAllWorkspacesAction = null;
    Action showInfoLogAction = null;
    Action showErrorLogAction = null;
    SystemProperties p = null;
    WorkerDlg worker = new WorkerDlg((Window)this, "Request is being processed...");
    Observer myObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (arg == JAMSCloudGraphicalController.JAMSCloudEvents.CONNECT) {
                BrowseJAMSCloudDlg.this.connect();
            }
            if (arg == JAMSCloudGraphicalController.JAMSCloudEvents.DISCONNECT) {
                BrowseJAMSCloudDlg.this.setVisible(false);
            }
        }
    };

    public BrowseJAMSCloudDlg(Window w, SystemProperties p) {
        super(w, JAMS.i18n((String)"JAMS-Cloud"));
        this.parent = w;
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(BrowseJAMSCloudDlg.class.getName()));
        this.isConnected = false;
        this.p = p;
        this.connector = JAMSCloudGraphicalController.createInstance(w, p);
        this.connector.addObserver(this.myObserver);
    }

    public void init() {
        this.initActions();
        this.mainPanel = new JPanel();
        GroupLayout mainLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainLayout);
        JButton uploadWs = new JButton(this.uploadWorkspaceAction);
        JScrollPane jobsScroller = new JScrollPane(this.jobsTree);
        jobsScroller.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Jobs")));
        JScrollPane workspaceTreeScroller = new JScrollPane(this.workspaceTree);
        workspaceTreeScroller.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Workspaces")));
        JPanel jobsPanel = new JPanel();
        jobsPanel.setLayout(new BorderLayout());
        JPanel wsPanel = new JPanel();
        wsPanel.setLayout(new BorderLayout());
        JPanel wsInfoPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        wsInfoPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        Insets insetsNone = new Insets(5, 2, 10, 2);
        Insets insetsSpace = new Insets(5, 5, 10, 0);
        c.insets = insetsNone;
        wsInfoPanel.add((Component)this.wsNameLabel, c);
        ++c.gridx;
        c.insets = insetsNone;
        wsInfoPanel.add((Component)this.wsName, c);
        ++c.gridx;
        c.insets = insetsSpace;
        wsInfoPanel.add((Component)this.wsCreationDate, c);
        ++c.gridx;
        c.insets = insetsNone;
        wsInfoPanel.add((Component)this.wsCreation, c);
        ++c.gridx;
        c.insets = insetsSpace;
        wsInfoPanel.add((Component)this.wsSizeLabel, c);
        ++c.gridx;
        c.insets = insetsNone;
        wsInfoPanel.add((Component)this.wsSize, c);
        this.wsName.setEnabled(false);
        this.wsCreation.setEnabled(false);
        this.wsSize.setEnabled(false);
        wsPanel.add((Component)workspaceTreeScroller, "Center");
        wsPanel.add((Component)uploadWs, "South");
        wsPanel.add((Component)wsInfoPanel, "North");
        JPanel jobInfoPanel = new JPanel();
        GridBagLayout layout2 = new GridBagLayout();
        jobInfoPanel.setLayout(layout2);
        c.insets = insetsNone;
        jobInfoPanel.add((Component)this.jobNameLabel, c);
        ++c.gridx;
        c.insets = insetsNone;
        jobInfoPanel.add((Component)this.jobName, c);
        ++c.gridx;
        c.insets = insetsSpace;
        jobInfoPanel.add((Component)this.jobCreationDate, c);
        ++c.gridx;
        c.insets = insetsNone;
        jobInfoPanel.add((Component)this.jobCreation, c);
        ++c.gridx;
        c.insets = insetsSpace;
        jobInfoPanel.add((Component)this.jobSizeLabel, c);
        ++c.gridx;
        c.insets = insetsNone;
        jobInfoPanel.add((Component)this.jobSize, c);
        this.jobName.setEnabled(false);
        this.jobCreation.setEnabled(false);
        this.jobSize.setEnabled(false);
        jobsPanel.add((Component)jobsScroller, "Center");
        jobsPanel.add((Component)jobInfoPanel, "North");
        this.viewPane.addTab(JAMS.i18n((String)"Jobs"), jobsPanel);
        this.viewPane.addTab(JAMS.i18n((String)"Workspaces"), wsPanel);
        this.statusLabel.setHorizontalAlignment(2);
        JSeparator sep1 = new JSeparator(0);
        mainLayout.setHorizontalGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(sep1).addGroup(mainLayout.createSequentialGroup().addGroup(mainLayout.createParallelGroup().addComponent(this.viewPane))).addComponent(this.statusLabel));
        mainLayout.setVerticalGroup(mainLayout.createSequentialGroup().addComponent(sep1, 5, 10, 15).addGroup(mainLayout.createParallelGroup().addGroup(mainLayout.createSequentialGroup().addComponent(this.viewPane))).addComponent(this.statusLabel));
        this.workspaceTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("empty")));
        this.jobsTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("empty")));
        this.add(this.mainPanel);
        this.invalidate();
        this.pack();
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            if (!this.connect()) {
                return;
            }
            this.updateViewAction();
        } else {
            this.disconnect();
        }
        super.setVisible(flag);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private void viewStream(WorkspaceFileAssociation wfa) {
        if (!this.isConnected) {
            return;
        }
        try {
            InputStream is = this.connector.getClient().files().getFileAsStream(wfa.getFile());
            ViewStreamDlg dlg = new ViewStreamDlg((Dialog)this, is, wfa.getFileName());
            dlg.setResizable(true);
            GUIHelper.centerOnParent((Window)dlg, (boolean)true);
            dlg.setVisible(true);
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, ioe.toString(), ioe);
        }
    }

    private void viewInfoLog(Job job) {
        WorkspaceFileAssociation wfa = job.getWorkspace().getFile("info.log");
        if (wfa != null) {
            this.viewStream(wfa);
        } else {
            log.info(JAMS.i18n((String)"Failed_to_show_info_log._The_file_is_not_existing!"));
        }
    }

    private void viewErrorLog(Job job) {
        WorkspaceFileAssociation wfa = job.getWorkspace().getFile("error.log");
        if (wfa != null) {
            this.viewStream(wfa);
        } else {
            log.info(JAMS.i18n((String)"Failed_to_show_error_log._The_file_is_not_existing!"));
        }
    }

    private void deleteWorkspace(Workspace ws) {
        if (!this.isConnected) {
            return;
        }
        if (!ws.isReadOnly()) {
            try {
                this.connector.getClient().workspaces().delete(ws);
                this.updateData();
            }
            catch (ProcessingException ioe) {
                log.log(Level.SEVERE, "Unable to delete workspace", ioe);
            }
        } else {
            log.severe(JAMS.i18n((String)"Workspace_with_id:%1_was_not_deleted,_since it_is_read-only!").replace("%1", Integer.toString(ws.getId())));
        }
    }

    private void deleteJob(Job job) {
        if (!this.isConnected) {
            return;
        }
        try {
            this.connector.getClient().jobs().delete(job);
            log.info(JAMS.i18n((String)"Job_deleted!"));
            this.updateData();
        }
        catch (ProcessingException ioe) {
            log.log(Level.SEVERE, JAMS.i18n((String)"Failed_to_delete_job!"), ioe);
        }
    }

    private void deleteAllJobs() {
        if (!this.isConnected) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, JAMS.i18n((String)"Are_you_sure_to_delete_all_jobs"), JAMS.i18n((String)"Please_confirm!"), 0);
        if (result == 0) {
            try {
                this.connector.getClient().jobs().deleteAll();
                log.info(JAMS.i18n((String)"All_jobs_were_deleted"));
                this.updateData();
            }
            catch (ProcessingException ioe) {
                log.log(Level.SEVERE, "Failed_to_delete_jobs!", ioe);
            }
        }
    }

    private void deleteAllWorkspaces() {
        if (!this.isConnected) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, JAMS.i18n((String)"Are_you_sure_to_delete_all_workspaces"), JAMS.i18n((String)"Please_confirm!"), 0);
        if (result == 0) {
            try {
                this.connector.getClient().workspaces().deleteAll();
                log.info(JAMS.i18n((String)"All_workspaces_were_deleted"));
                this.updateData();
            }
            catch (ProcessingException ioe) {
                log.log(Level.SEVERE, "Failed_to_delete_workspaces!", ioe);
            }
        }
    }

    private void killJob(Job job) {
        if (!this.isConnected) {
            return;
        }
        try {
            this.connector.getClient().jobs().kill(job);
            log.info(JAMS.i18n((String)"Job_with_id:%1_was_killed!").replace("%1", Integer.toString(job.getId())));
            this.updateData();
        }
        catch (ProcessingException ioe) {
            log.log(Level.SEVERE, JAMS.i18n((String)"Failed_to_kill_job_with_id:%1!").replace("%1", Integer.toString(job.getId())), ioe);
        }
    }

    private void updateJob(Job job) {
        if (!this.isConnected) {
            return;
        }
        this.jobsTree.updateNode(job);
    }

    private void updateViewAction() {
        if (this.connector == null) {
            return;
        }
        WorkerDlg dlg = new WorkerDlg(this.parent, JAMS.i18n((String)"Retrieving_data"));
        dlg.setInderminate(true);
        dlg.setTask(new Runnable(){

            @Override
            public void run() {
                BrowseJAMSCloudDlg.this.updateData();
            }
        });
        dlg.execute();
    }

    private void initActions() {
        this.deleteJobAction = new AbstractAction(JAMS.i18n((String)"Delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                if (job != null) {
                    abstract class ParameterizedRunnable<T>
                    extends ErrorCatchingRunnable {
                        T arg;

                        ParameterizedRunnable(T t) {
                            this.arg = t;
                        }
                    }
                    BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<Job>(job){
                        {
                            super(t);
                        }

                        public void safeRun() throws Exception {
                            BrowseJAMSCloudDlg.this.deleteJob((Job)this.arg);
                        }
                    }));
                    BrowseJAMSCloudDlg.this.worker.execute();
                }
            }
        };
        this.deleteAllJobsAction = new AbstractAction(JAMS.i18n((String)"Remove_all")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowseJAMSCloudDlg.this.worker.setTask(new Runnable(){

                    @Override
                    public void run() {
                        BrowseJAMSCloudDlg.this.deleteAllJobs();
                    }
                });
                BrowseJAMSCloudDlg.this.worker.execute();
            }
        };
        this.killJobAction = new AbstractAction(JAMS.i18n((String)"Kill")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                if (job != null) {
                    BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<Job>(job){
                        {
                            super(t);
                        }

                        public void safeRun() throws Exception {
                            BrowseJAMSCloudDlg.this.killJob((Job)this.arg);
                        }
                    }));
                    BrowseJAMSCloudDlg.this.worker.execute();
                }
            }
        };
        this.updateJobAction = new AbstractAction(JAMS.i18n((String)"Update")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                if (job != null) {
                    BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<Job>(job){
                        {
                            super(t);
                        }

                        public void safeRun() throws Exception {
                            BrowseJAMSCloudDlg.this.updateJob((Job)this.arg);
                        }
                    }));
                    BrowseJAMSCloudDlg.this.worker.execute();
                }
            }
        };
        this.showInfoLogAction = new AbstractAction(JAMS.i18n((String)"View_Info_Log")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                if (job != null) {
                    BrowseJAMSCloudDlg.this.viewInfoLog(job);
                }
            }
        };
        this.showErrorLogAction = new AbstractAction(JAMS.i18n((String)"View_Error_Log")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                if (job != null) {
                    BrowseJAMSCloudDlg.this.viewErrorLog(job);
                }
            }
        };
        this.startWorkspaceAction = new AbstractAction(JAMS.i18n((String)"Start_Job")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceFileAssociation wfa = BrowseJAMSCloudDlg.this.getSelectedFile();
                if (wfa != null && wfa.getRole() == 2) {
                    BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<WorkspaceFileAssociation>(wfa){
                        {
                            super(t);
                        }

                        public void safeRun() throws Exception {
                            BrowseJAMSCloudDlg.this.startJob(((WorkspaceFileAssociation)this.arg).getWorkspace(), (WorkspaceFileAssociation)this.arg);
                        }
                    }));
                    BrowseJAMSCloudDlg.this.worker.execute();
                }
            }
        };
        this.downloadWorkspaceAction = new AbstractAction(JAMS.i18n((String)"Download")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace ws = null;
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                ws = job != null ? job.getWorkspace() : BrowseJAMSCloudDlg.this.workspaceTree.getSelectedWorkspace();
                if (ws == null) {
                    return;
                }
                BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<Workspace>(ws){
                    {
                        super(t);
                    }

                    public void safeRun() throws Exception {
                        BrowseJAMSCloudDlg.this.jfc.setFileSelectionMode(1);
                        try {
                            BrowseJAMSCloudDlg.this.jfc.setSelectedFile(GUIState.getSavePath().getParentFile());
                            File safePath = GUIState.getSavePath();
                            if (safePath != null) {
                                BrowseJAMSCloudDlg.this.jfc.setCurrentDirectory(safePath.getParentFile());
                            }
                        }
                        catch (IndexOutOfBoundsException ex) {
                            BrowseJAMSCloudDlg.this.jfc.setSelectedFile(GUIState.getSavePath().getParentFile());
                            BrowseJAMSCloudDlg.this.jfc.setCurrentDirectory(GUIState.getSavePath().getParentFile());
                        }
                        int result = BrowseJAMSCloudDlg.this.jfc.showSaveDialog(BrowseJAMSCloudDlg.this);
                        if (result == 0) {
                            File target = BrowseJAMSCloudDlg.this.jfc.getSelectedFile();
                            BrowseJAMSCloudDlg.this.connector.downloadWorkspace((Workspace)this.arg, target);
                            log.info(JAMS.i18n((String)"Download_complete"));
                        }
                    }
                }));
                BrowseJAMSCloudDlg.this.worker.execute();
            }
        };
        this.downloadFileAction = new AbstractAction("Download"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceFileAssociation wfa = BrowseJAMSCloudDlg.this.getSelectedFile();
                if (wfa == null) {
                    return;
                }
                BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<WorkspaceFileAssociation>(wfa){
                    {
                        super(t);
                    }

                    public void safeRun() throws Exception {
                        BrowseJAMSCloudDlg.this.jfc.setFileSelectionMode(1);
                        try {
                            BrowseJAMSCloudDlg.this.jfc.setSelectedFile(GUIState.getSavePath().getParentFile());
                            BrowseJAMSCloudDlg.this.jfc.setCurrentDirectory(GUIState.getSavePath().getParentFile());
                        }
                        catch (IndexOutOfBoundsException ex) {
                            BrowseJAMSCloudDlg.this.jfc.setSelectedFile(GUIState.getSavePath().getParentFile());
                            BrowseJAMSCloudDlg.this.jfc.setCurrentDirectory(GUIState.getSavePath().getParentFile());
                        }
                        int result = BrowseJAMSCloudDlg.this.jfc.showSaveDialog(BrowseJAMSCloudDlg.this);
                        if (result == 0) {
                            File target = BrowseJAMSCloudDlg.this.jfc.getSelectedFile();
                            BrowseJAMSCloudDlg.this.connector.downloadFile((WorkspaceFileAssociation)this.arg, target);
                            log.info(JAMS.i18n((String)"Download_complete"));
                        }
                    }
                }));
                BrowseJAMSCloudDlg.this.worker.execute();
            }
        };
        this.deleteWorkspaceAction = new AbstractAction(JAMS.i18n((String)"Delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workspace ws = BrowseJAMSCloudDlg.this.workspaceTree.getSelectedWorkspace();
                if (ws == null) {
                    return;
                }
                BrowseJAMSCloudDlg.this.worker.setTask((Runnable)((Object)new ParameterizedRunnable<Workspace>(ws){
                    {
                        super(t);
                    }

                    public void safeRun() throws Exception {
                        BrowseJAMSCloudDlg.this.deleteWorkspace((Workspace)this.arg);
                    }
                }));
                BrowseJAMSCloudDlg.this.worker.execute();
            }
        };
        this.deleteAllWorkspacesAction = new AbstractAction(JAMS.i18n((String)"Remove_all")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowseJAMSCloudDlg.this.worker.setTask(new Runnable(){

                    @Override
                    public void run() {
                        BrowseJAMSCloudDlg.this.deleteAllWorkspaces();
                    }
                });
                BrowseJAMSCloudDlg.this.worker.execute();
            }
        };
        this.uploadWorkspaceAction = new AbstractAction(JAMS.i18n((String)"Upload_Workspace")){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadWorkspaceDlg dialog = new UploadWorkspaceDlg((Window)null, BrowseJAMSCloudDlg.this.connector.getClient());
                dialog.setModal(true);
                dialog.setVisible(true);
                if (dialog.getUploadSuccessful()) {
                    BrowseJAMSCloudDlg.this.updateViewAction();
                }
            }
        };
        this.showFileProperties = new AbstractAction(JAMS.i18n((String)"Properties")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceFileAssociation wfa = BrowseJAMSCloudDlg.this.getSelectedFile();
                if (wfa == null) {
                    return;
                }
                FilePropertiesDlg fpDlg = new FilePropertiesDlg((Window)null);
                fpDlg.setFile(wfa);
                fpDlg.addPropertyChangeListener("ROLE", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getSource() instanceof WorkspaceFileAssociation) {
                            WorkspaceFileAssociation wfa = (WorkspaceFileAssociation)evt.getSource();
                            int role = (Integer)evt.getNewValue();
                            wfa.setRole(role);
                            BrowseJAMSCloudDlg.this.connector.getClient().workspaces().attachFile(wfa.getWorkspace(), wfa);
                        }
                    }
                });
                fpDlg.setVisible(true);
            }
        };
        final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy hh:mm");
        this.workspaceTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JAMSServerTreeNodes.SortedMutableTreeNode node;
                Workspace ws = BrowseJAMSCloudDlg.this.workspaceTree.getSelectedWorkspace();
                if (ws == null && (node = BrowseJAMSCloudDlg.this.jobsTree.getSelectedNode()) instanceof JAMSServerTreeNodes.WFANode) {
                    JAMSServerTreeNodes.WFANode wfaNode = (JAMSServerTreeNodes.WFANode)node;
                    ws = wfaNode.getWFA().getWorkspace();
                }
                if (ws != null) {
                    BrowseJAMSCloudDlg.this.wsName.setText(ws.getName());
                    BrowseJAMSCloudDlg.this.wsCreation.setText(sdf.format(ws.getCreationDate()));
                    BrowseJAMSCloudDlg.this.wsSize.setText(StringTools.humanReadableByteCount((long)ws.getWorkspaceSize(), (boolean)false));
                }
            }
        });
        this.jobsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Job job = BrowseJAMSCloudDlg.this.jobsTree.getSelectedJob();
                if (job != null) {
                    BrowseJAMSCloudDlg.this.jobName.setText(job.getWorkspace().getName());
                    if (job.getStartTime() != null) {
                        BrowseJAMSCloudDlg.this.jobCreation.setText(sdf.format(job.getStartTime()));
                    } else {
                        BrowseJAMSCloudDlg.this.jobCreation.setText(JAMS.i18n((String)"not_started"));
                    }
                    BrowseJAMSCloudDlg.this.jobSize.setText(StringTools.humanReadableByteCount((long)job.getWorkspace().getWorkspaceSize(), (boolean)false));
                } else {
                    JAMSServerTreeNodes.SortedMutableTreeNode node = BrowseJAMSCloudDlg.this.jobsTree.getSelectedNode();
                    if (node instanceof JAMSServerTreeNodes.WFANode) {
                        JAMSServerTreeNodes.WFANode wFANode = (JAMSServerTreeNodes.WFANode)node;
                    }
                }
            }
        });
        this.workspaceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Object userObject = BrowseJAMSCloudDlg.this.workspaceTree.getUserObjectAtLocation(e);
                if (userObject instanceof WorkspaceFileAssociation) {
                    WorkspaceFileAssociation wfa = (WorkspaceFileAssociation)userObject;
                    BrowseJAMSCloudDlg.this.viewStream(wfa);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 3) {
                    return;
                }
                Object userObject = BrowseJAMSCloudDlg.this.workspaceTree.getUserObjectAtLocation(e);
                JPopupMenu popup = new JPopupMenu();
                if (userObject instanceof User) {
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.deleteAllWorkspacesAction));
                }
                if (userObject instanceof WorkspaceFileAssociation) {
                    WorkspaceFileAssociation wfa = (WorkspaceFileAssociation)userObject;
                    if (wfa.getRole() == 2 && wfa.getWorkspace() != null && !wfa.getWorkspace().isReadOnly()) {
                        popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.startWorkspaceAction));
                    }
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.downloadFileAction));
                    popup.add(new JSeparator());
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.showFileProperties));
                } else if (userObject instanceof Workspace) {
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.downloadWorkspaceAction));
                    Workspace ws = (Workspace)userObject;
                    if (!ws.isReadOnly()) {
                        popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.deleteWorkspaceAction));
                    }
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.jobsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Object userObject = BrowseJAMSCloudDlg.this.jobsTree.getUserObjectAtLocation(e);
                if (userObject != null && userObject instanceof WorkspaceFileAssociation) {
                    WorkspaceFileAssociation wfa = (WorkspaceFileAssociation)userObject;
                    BrowseJAMSCloudDlg.this.viewStream(wfa);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 3) {
                    return;
                }
                Object userObject = BrowseJAMSCloudDlg.this.jobsTree.getUserObjectAtLocation(e);
                if (userObject == null) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                if (userObject instanceof User) {
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.deleteAllJobsAction));
                }
                if (userObject instanceof WorkspaceFileAssociation) {
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.downloadFileAction));
                    popup.add(new JSeparator());
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.showFileProperties));
                } else if (userObject instanceof Job) {
                    Job job = (Job)userObject;
                    if (job.getPID() > 0) {
                        popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.killJobAction));
                    }
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.downloadWorkspaceAction));
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.deleteJobAction));
                    popup.add(new JSeparator());
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.showInfoLogAction));
                    popup.add(new JMenuItem(BrowseJAMSCloudDlg.this.showErrorLogAction));
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowseJAMSCloudDlg.this.updateViewAction();
            }
        }, KeyStroke.getKeyStroke(116, 0), 2);
    }

    private boolean connect() {
        try {
            if (!this.connector.isConnected()) {
                this.isConnected = false;
                if (this.connector.reconnect() == null) {
                    return false;
                }
                this.isConnected = true;
            } else {
                this.isConnected = true;
            }
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, ioe.toString(), ioe);
            return false;
        }
        this.observable.deleteObservers();
        this.observable.setThreadID(Thread.currentThread().getId());
        this.observable.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                BrowseJAMSCloudDlg.this.statusLabel.setText(arg.toString());
            }
        });
        this.setURL(this.connector.getServerUrl());
        return true;
    }

    private void setURL(String url) {
        this.setTitle(JAMS.i18n((String)"JAMS-Cloud") + " [" + url + "] ");
    }

    private void disconnect() {
        if (this.isConnected) {
            // empty if block
        }
    }

    private void startJob(Workspace ws, WorkspaceFileAssociation f) {
        if (this.connector != null) {
            this.connector.startJob(ws, f);
        }
    }

    private WorkspaceFileAssociation getSelectedFile() {
        JAMSServerTreeNodes.SortedMutableTreeNode o = null;
        if (this.jobsTree.isShowing()) {
            o = this.jobsTree.getSelectedNode();
        } else if (this.workspaceTree.isShowing()) {
            o = this.workspaceTree.getSelectedNode();
        }
        if (o != null && o instanceof JAMSServerTreeNodes.WFANode) {
            return ((JAMSServerTreeNodes.WFANode)o).getWFA();
        }
        return null;
    }

    private void updateData() {
        if (!this.isConnected) {
            return;
        }
        this.jobs = this.connector.getClient().jobs().find();
        for (Job job : this.jobs.getJobs()) {
            if (job.getPID() <= 0) continue;
            try {
                if (this.connector.getClient().jobs().getState(job).isActive()) continue;
                job.setPID(-1);
            }
            catch (ProcessingException ioe) {
                log.log(Level.WARNING, "Unable to retrive state of job with id " + job.getId(), ioe);
            }
        }
        try {
            User user = this.connector.getClient().getUser();
            Workspaces wsList = this.connector.getClient().workspaces().findAll(null);
            Jobs jobList = this.connector.getClient().jobs().find();
            this.workspaceTree.generateModel(user, wsList);
            this.jobsTree.generateModel(user, jobList, this.connector.getClient().jobs());
        }
        catch (ProcessingException t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    public static void main(String[] args) {
        BrowseJAMSCloudDlg gui = new BrowseJAMSCloudDlg(null, null);
        gui.init();
        GUIHelper.centerOnScreen((Component)gui, (boolean)true);
        gui.setVisible(true);
    }
}

