/*
 * Decompiled with CFR 0.152.
 */
package jams.server.client;

import jams.JAMS;
import jams.server.client.Controller;
import jams.server.client.FileController;
import jams.server.client.HTTPClient;
import jams.server.client.sync.DirectorySync;
import jams.server.client.sync.FileSync;
import jams.server.entities.Files;
import jams.server.entities.Workspace;
import jams.server.entities.WorkspaceFileAssociation;
import jams.server.entities.WorkspaceFileAssociations;
import jams.server.entities.Workspaces;
import jams.tools.FileTools;
import jams.tools.LogTools;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import javax.ws.rs.ProcessingException;

public class WorkspaceController {
    private final FileController fileController;
    private final HTTPClient client;
    private final String urlStr;

    public WorkspaceController(Controller ctrl) {
        this.client = ctrl.getClient();
        this.urlStr = ctrl.getServerURL();
        this.fileController = ctrl.files();
    }

    public Workspace delete(Workspace ws) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Delete_workspace_with_id:{0}"), (Object[])new Object[]{ws.getId()});
        return this.client.httpGet(this.urlStr + "/workspace/" + ws.getId() + "/delete", Workspace.class);
    }

    public void deleteAll() {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Delete_all_workspace_of_the_user."), (Object[])new Object[0]);
        this.client.httpGet(this.urlStr + "/workspace/reset", String.class);
    }

    public Workspace create(Workspace ws) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Creating_a_new_workspace"), (Object[])new Object[0]);
        return this.client.httpPost(this.urlStr + "/workspace/create", "PUT", ws, Workspace.class);
    }

    public Workspaces find(int id) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"searching_for_workspace_with_id_{0}"), (Object[])new Object[]{id});
        return this.client.httpGet(this.urlStr + "/workspace/" + id, Workspaces.class);
    }

    public Workspace ensureExistance(int id, String name) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"ensures_existance_of_workspace_with_id_{0}_and_name_{1}"), (Object[])new Object[]{id, name});
        Workspaces workspaces = null;
        if (id > 0) {
            workspaces = this.find(id);
        }
        if (workspaces == null || workspaces.getWorkspaces().isEmpty()) {
            Workspace ws = new Workspace();
            ws.setName(name);
            ws = this.create(ws);
            return ws;
        }
        return (Workspace)workspaces.getWorkspaces().get(0);
    }

    public Workspaces findAll(String name) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"searching_for_all_workspaces__named_{0}"), (Object[])new Object[]{name});
        if (name == null) {
            return this.client.httpGet(this.urlStr + "/workspace/find", Workspaces.class);
        }
        return this.client.httpGet(this.urlStr + "/workspace/find?name=" + name, Workspaces.class);
    }

    public Workspace attachFile(Workspace ws, WorkspaceFileAssociation wfa) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"attaches_the_file_{0}_to_the_workspace_{1}"), (Object[])new Object[]{wfa.getFile(), ws.getName()});
        ArrayList<WorkspaceFileAssociation> wfas = new ArrayList<WorkspaceFileAssociation>();
        wfas.add(wfa);
        return this.attachFiles(ws, wfas);
    }

    public Workspace attachFiles(Workspace ws, Collection<WorkspaceFileAssociation> wfas) {
        WorkspaceFileAssociations request = new WorkspaceFileAssociations(wfas);
        return this.client.httpPost(this.urlStr + "/workspace/" + ws.getId() + "/assign", "POST", request, Workspace.class);
    }

    public Workspace detachFile(Workspace ws, String relativePath) {
        String encodedPath;
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"detaches_the_file_{0}_from_the_workspace_{1}"), (Object[])new Object[]{relativePath, ws.getName()});
        try {
            encodedPath = URLEncoder.encode(relativePath, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ProcessingException((Throwable)uee);
        }
        return this.client.httpGet(this.urlStr + "/workspace/" + ws.getId() + "/detach?RELATIVE_PATH=" + encodedPath, Workspace.class);
    }

    public Workspace detachAll(Workspace ws) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"detaches_all_files_from_the_workspace_{0}"), (Object[])new Object[]{ws.getName()});
        return this.client.httpGet(this.urlStr + "/workspace/" + ws.getId() + "/detachAll", Workspace.class);
    }

    public File downloadFile(File target, WorkspaceFileAssociation wfa) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"downloading_{0}_to_{1}"), (Object[])new Object[]{wfa.getFileName(), target.getAbsoluteFile()});
        return this.client.download(this.urlStr + "/workspace/download/" + wfa.getWorkspace().getId() + "/" + wfa.getID(), target);
    }

    public File downloadWorkspace(File target, Workspace ws) throws IOException {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"downloading_workspace_{0}_to_{1}"), (Object[])new Object[]{ws.getId(), target.getAbsoluteFile()});
        File zip = this.client.download(this.urlStr + "/workspace/download/" + ws.getId(), target);
        FileTools.unzipFile((File)zip, (File)new File(target, ws.getName()), (boolean)true);
        return target;
    }

    public DirectorySync getSynchronizationList(File localWsDirectory, Workspace remoteWs) {
        DirectorySync rootSync = new DirectorySync(this, null, localWsDirectory);
        Files files = new Files();
        HashMap<Integer, jams.server.entities.File> lookupTable = new HashMap<Integer, jams.server.entities.File>();
        for (WorkspaceFileAssociation wfa : remoteWs.getFiles()) {
            files.add(wfa.getFile());
        }
        files = this.fileController.getHashCode(files);
        for (jams.server.entities.File f : files.getFiles()) {
            lookupTable.put(f.getId(), f);
        }
        for (WorkspaceFileAssociation wfa : remoteWs.getFiles()) {
            jams.server.entities.File f = (jams.server.entities.File)lookupTable.get(wfa.getFile().getId());
            if (wfa.getWorkspace() == null) {
                wfa.setWorkspace(remoteWs);
            }
            wfa.getFile().setHash(f.getHash());
            rootSync.createSyncEntry(wfa.getPath(), wfa);
        }
        rootSync.updateSyncMode();
        return rootSync;
    }

    public boolean synchronizeWorkspace(DirectorySync root) {
        LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Start_synchronization_of_{0}"), (Object[])new Object[]{root.getLocalFileName()});
        if (!root.isDoSync()) {
            return true;
        }
        if (root.getSyncMode() == FileSync.SyncMode.NOTHING) {
            return true;
        }
        if (!(root.getSyncMode() != FileSync.SyncMode.CREATE && root.getSyncMode() != FileSync.SyncMode.DUPLICATE || root.getTargetFile().mkdirs())) {
            return false;
        }
        if (root.getSyncMode() == FileSync.SyncMode.UPDATE) {
            // empty if block
        }
        boolean success = true;
        for (FileSync fs : root.getChildren()) {
            success &= this.synchronizeWorkspace(fs);
        }
        if (root.getParent() == null) {
            LogTools.log(this.getClass(), (Level)Level.INFO, (String)JAMS.i18n((String)"Synchronization_of_%1_is_completed").replace("%1", root.getLocalFileName()), (Object[])new Object[0]);
        } else {
            LogTools.log(this.getClass(), (Level)Level.FINE, (String)JAMS.i18n((String)"Synchronization_of_%1_is_completed").replace("%1", root.getLocalFileName()), (Object[])new Object[0]);
        }
        return success;
    }

    private boolean synchronizeWorkspace(FileSync root) {
        if (root instanceof DirectorySync) {
            return this.synchronizeWorkspace((DirectorySync)root);
        }
        if (!root.isDoSync()) {
            return true;
        }
        if (root.getSyncMode() == FileSync.SyncMode.NOTHING) {
            return true;
        }
        if (root.getSyncMode() == FileSync.SyncMode.CREATE || root.getSyncMode() == FileSync.SyncMode.DUPLICATE || root.getSyncMode() == FileSync.SyncMode.UPDATE) {
            try {
                this.downloadFile(root.getTargetFile().getParentFile(), root.getServerFile());
            }
            catch (IOException ioe) {
                LogTools.log(this.getClass(), (Level)Level.SEVERE, (String)("Unable to download " + root.getServerFile().getFileName()), (Object[])new Object[]{ioe});
                return false;
            }
        }
        return true;
    }

    public FileController getFileController() {
        return this.fileController;
    }
}

