/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui;

import java.awt.Color;
import java.util.ArrayList;

public class ColorRamp {
    private final Color startColor;
    private final Color endColor;
    private int steps;
    private final ArrayList<Color> colorRamp;

    public ColorRamp(Color start, Color end, int steps) throws IllegalArgumentException {
        if (steps > 255 || steps < 0) {
            throw new IllegalArgumentException("STEPS MUST BE IN THAT RANGE [0,255].");
        }
        this.startColor = start;
        this.endColor = end;
        this.steps = steps;
        this.colorRamp = new ArrayList(this.steps);
        this.calculateRamp();
    }

    private void calculateRamp() {
        int rSteps = (this.startColor.getRed() - this.endColor.getRed()) / this.steps;
        int gSteps = (this.startColor.getGreen() - this.endColor.getGreen()) / this.steps;
        int bSteps = (this.startColor.getBlue() - this.endColor.getBlue()) / this.steps;
        this.colorRamp.add(this.startColor);
        for (int i = 1; i < this.steps; ++i) {
            int red = rSteps < 0 ? this.endColor.getRed() + (this.steps - i) * rSteps : this.startColor.getRed() - i * rSteps;
            int green = gSteps < 0 ? this.endColor.getGreen() + (this.steps - i) * gSteps : this.startColor.getGreen() - i * gSteps;
            int blue = bSteps < 0 ? this.endColor.getBlue() + (this.steps - i) * bSteps : this.startColor.getBlue() - i * bSteps;
            this.colorRamp.add(new Color(red, green, blue));
        }
        this.colorRamp.add(this.endColor);
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public int getSteps() {
        return this.steps;
    }

    public ArrayList<Color> getColorRamp() {
        return this.colorRamp;
    }

    public Color getColor(int index) {
        return this.colorRamp.get(index);
    }
}

