/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.test;

import gov.nasa.worldwind.render.Material;
import jams.worldwind.ui.renderer.MaterialClassCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PropertyEditorCellRenderer
extends JLabel
implements TableCellRenderer {
    private Color colorSelected = new Color(200, 255, 200);
    private Color colorFocus = new Color(255, 200, 200);
    private Color colorNormal = new Color(200, 200, 255);

    public PropertyEditorCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(null);
        this.setIcon(null);
        if (value instanceof Short) {
            this.setText(((Short)value).toString());
        }
        if (value instanceof Integer) {
            this.setText(((Integer)value).toString());
        }
        if (value instanceof Long) {
            this.setText(((Long)value).toString());
        }
        if (value instanceof Float) {
            this.setText(((Float)value).toString());
        }
        if (value instanceof Double) {
            this.setText(((Double)value).toString());
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else if (value instanceof Color) {
            Color color = (Color)value;
            this.setForeground(color);
            this.setText(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
        } else if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this.setText("true");
            } else {
                this.setText("false");
            }
        } else {
            if (value instanceof Material) {
                return new MaterialClassCellRenderer(true).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (value == null) {
                this.setText("not defined");
            } else {
                this.setText(value.toString());
            }
        }
        return this;
    }
}

