/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui.tree;

import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jamsui.juice.gui.tree.JAMSNode;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JAMSTree
extends JTree {
    private Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    private Enumeration<TreePath> expandedPaths;
    private ComponentCollection componentCollection;

    public JAMSTree(ComponentCollection componentCollection) {
        this.setAutoscrolls(true);
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setSelectionRow(0);
        this.setCellRenderer(new JAMSTreeRenderer());
        this.componentCollection = componentCollection;
        this.setRowHeight(this.getFont().getSize() + 4);
    }

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return false;
    }

    @Override
    public void updateUI() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JAMSTree.super.updateUI();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            super.updateUI();
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public static DefaultMutableTreeNode makeDeepCopy(JAMSNode node, JAMSTree target) {
        JAMSNode copy = node.clone(target);
        ComponentDescriptor cd = (ComponentDescriptor)copy.getUserObject();
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            copy.add(JAMSTree.makeDeepCopy((JAMSNode)((Object)e.nextElement()), target));
        }
        return copy;
    }

    public ComponentCollection getComponentCollection() {
        return this.componentCollection;
    }

    public void setComponentCollection(ComponentCollection componentCollection) {
        this.componentCollection = componentCollection;
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row > 0; --row) {
            this.collapseRow(row);
        }
    }

    public void saveExpandedState(TreePath sourcePath) {
        this.expandedPaths = this.getExpandedDescendants(sourcePath);
    }

    public void restoreExpandedState() {
        if (this.expandedPaths != null) {
            while (this.expandedPaths.hasMoreElements()) {
                TreePath tmpPath = this.expandedPaths.nextElement();
                this.expandPath(new TreePath(((DefaultMutableTreeNode)tmpPath.getLastPathComponent()).getPath()));
            }
        }
    }

    class JAMSTreeRenderer
    extends DefaultTreeCellRenderer {
        JAMSTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreeNode node = (TreeNode)value;
            if (node instanceof JAMSNode) {
                JAMSNode jNode = (JAMSNode)((Object)node);
                this.setIcon(JAMSNode.NODE_ICON[jNode.getType()]);
                Object o = jNode.getUserObject();
                if (o instanceof ComponentDescriptor) {
                    ComponentDescriptor cd = (ComponentDescriptor)o;
                    this.setEnabled(cd.isEnabled());
                }
            }
            return this;
        }
    }
}

