/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.data.JAMSString;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextDescriptor;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jamsui.juice.JUICE;
import jamsui.juice.gui.tree.JAMSNode;
import jamsui.juice.gui.tree.JAMSTree;
import jamsui.juice.gui.tree.LibTree;
import jamsui.juice.gui.tree.ModelTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class SearchDlg
extends JDialog {
    private static final int TEXTFIELD_WIDTH = 35;
    private static final int FOUND_IN_CLASS = 1;
    private static final int FOUND_IN_INSTANCE = 2;
    private static final int FOUND_IN_CONTEXT_ATTRIBS = 3;
    private static final int FOUND_IN_COMPONENT_ATTRIBS = 4;
    private static final int FOUND_IN_COMPONENT_VALUES = 5;
    private static final int FOUND_IN_COMPONENT_METADATA = 6;
    private JAMSTree tree;
    private Enumeration treeEnum;
    private JCheckBox inClassName;
    private JCheckBox inInstanceName;
    private JCheckBox inContextAttribs;
    private JCheckBox inComponentAttribs;
    private JCheckBox inComponentValues;
    private JCheckBox inComponentMetadata;
    private JCheckBox caseSensitive;
    private JCheckBox wholeString;
    private InputComponent searchText;
    private JRadioButton repo;
    private JRadioButton model;
    private boolean modelSelect = true;
    private boolean foundResult = false;

    public SearchDlg(Frame owner) {
        super(owner);
        this.setLocationRelativeTo(owner);
        this.setModal(false);
        this.setResizable(false);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        GridBagLayout mainLayout = new GridBagLayout();
        contentPanel.setLayout(mainLayout);
        this.inClassName = new JCheckBox(JAMS.i18n((String)"inClassName"), true);
        this.inInstanceName = new JCheckBox(JAMS.i18n((String)"inInstanceName"), true);
        this.inContextAttribs = new JCheckBox(JAMS.i18n((String)"inContextAttribs"), true);
        this.inComponentAttribs = new JCheckBox(JAMS.i18n((String)"inComponentAttribs"), true);
        this.inComponentValues = new JCheckBox(JAMS.i18n((String)"inComponentValues"), true);
        this.inComponentMetadata = new JCheckBox(JAMS.i18n((String)"inComponentMetadata"), true);
        this.caseSensitive = new JCheckBox(JAMS.i18n((String)"caseSensitiveSearch"), false);
        this.wholeString = new JCheckBox(JAMS.i18n((String)"wholeStringSearch"), false);
        this.searchText = InputComponentFactory.createInputComponent(JAMSString.class);
        this.searchText.setLength(35);
        this.repo = new JRadioButton(JAMS.i18n((String)"Search_in_Repo"));
        this.model = new JRadioButton(JAMS.i18n((String)"Search_in_Model"));
        this.model.setSelected(true);
        this.repo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchDlg.this.repo.isSelected() && SearchDlg.this.modelSelect) {
                    SearchDlg.this.modelSelect = false;
                    SearchDlg.this.setTree(JUICE.getLibTree());
                }
            }
        });
        this.model.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchDlg.this.model.isSelected() && !SearchDlg.this.modelSelect) {
                    SearchDlg.this.modelSelect = true;
                    SearchDlg.this.setTree(JUICE.getJuiceFrame().getCurrentView().getTree());
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.repo);
        group.add(this.model);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)new JLabel(JAMS.i18n((String)"Search_text")), (int)1, (int)0, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.searchText.getComponent(), (int)1, (int)1, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.model, (int)1, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.repo, (int)2, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.caseSensitive, (int)1, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.wholeString, (int)2, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)new JLabel(JAMS.i18n((String)"Where_to_search")), (int)1, (int)10, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.inClassName, (int)1, (int)11, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.inComponentAttribs, (int)1, (int)12, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.inComponentMetadata, (int)1, (int)14, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.inInstanceName, (int)1, (int)16, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.inComponentValues, (int)1, (int)18, (int)2, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.inContextAttribs, (int)1, (int)20, (int)2, (int)1, (double)0.0, (double)0.0);
        JButton findButton = new JButton(JAMS.i18n((String)"Find"));
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDlg.this.processFind();
            }
        });
        JButton resetButton = new JButton(JAMS.i18n((String)"ResetSearch"));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDlg.this.reset();
                SearchDlg.this.processFind();
            }
        });
        JButton closeButton = new JButton(JAMS.i18n((String)"Close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDlg.this.processClose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(findButton);
        buttonPanel.add(resetButton);
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.getRootPane().setDefaultButton(findButton);
    }

    private void reset() {
        JAMSNode rootNode = (JAMSNode)((Object)this.tree.getModel().getRoot());
        this.treeEnum = rootNode.preorderEnumeration();
        this.foundResult = false;
    }

    public void setTree(JAMSTree tree) {
        this.tree = tree;
        if (tree instanceof LibTree) {
            this.setTitle(JAMS.i18n((String)"Search_in_Repo"));
            this.inInstanceName.setEnabled(false);
            this.inComponentValues.setEnabled(false);
            this.inContextAttribs.setEnabled(false);
        } else if (tree instanceof ModelTree) {
            this.setTitle(JAMS.i18n((String)"Search_in_Model"));
            this.inInstanceName.setEnabled(true);
            this.inComponentValues.setEnabled(true);
            this.inContextAttribs.setEnabled(true);
        }
        this.reset();
    }

    private void processFind() {
        while (this.treeEnum.hasMoreElements()) {
            ComponentDescriptor cd;
            JAMSNode node = (JAMSNode)((Object)this.treeEnum.nextElement());
            if (node.getType() != 0 && node.getType() != 1 && node.getType() != 2 || this.find(cd = (ComponentDescriptor)node.getUserObject(), this.searchText.getValue(), this.caseSensitive.isSelected(), this.wholeString.isSelected()) == -1) continue;
            TreePath resultPath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(resultPath);
            this.tree.setSelectionPath(resultPath);
            this.foundResult = true;
            return;
        }
        if (!this.foundResult) {
            GUIHelper.showInfoDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"No_searchresults_txt"), (String)JAMS.i18n((String)"Search_finished"));
            this.reset();
            return;
        }
        if (GUIHelper.showYesNoDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"No_further_searchresults_txt"), (String)JAMS.i18n((String)"Search_finished")) == 0) {
            this.reset();
            this.processFind();
        }
    }

    private int find(ComponentDescriptor cd, String needle, boolean caseSensitive, boolean wholeString) {
        if (this.inClassName.isSelected() && this.contains(cd.getClazz().getName(), needle, caseSensitive, wholeString)) {
            return 1;
        }
        if (this.inInstanceName.isSelected() && this.contains(cd.getInstanceName(), needle, caseSensitive, wholeString)) {
            return 2;
        }
        if (this.inComponentAttribs.isSelected()) {
            for (ComponentField ca : cd.getComponentFields().values()) {
                if (!this.contains(ca.getName(), needle, caseSensitive, wholeString)) continue;
                return 4;
            }
        }
        if (this.inComponentValues.isSelected()) {
            for (ComponentField ca : cd.getComponentFields().values()) {
                if (ca.getValue() != null && this.contains(ca.getValue().toString(), needle, caseSensitive, wholeString)) {
                    return 5;
                }
                if (ca.getAttribute() == null || !this.contains(ca.getAttribute(), needle, caseSensitive, wholeString)) continue;
                return 5;
            }
        }
        if (this.inContextAttribs.isSelected() && cd instanceof ContextDescriptor) {
            for (String hay : ((ContextDescriptor)cd).getStaticAttributes().keySet()) {
                if (!this.contains(hay, needle, caseSensitive, wholeString)) continue;
                return 3;
            }
        }
        if (this.inComponentMetadata.isSelected()) {
            Class clazz = cd.getClazz();
            JAMSComponentDescription jcd = clazz.getAnnotation(JAMSComponentDescription.class);
            if (jcd != null) {
                String[] hayArray;
                String[] stringArray = hayArray = new String[]{jcd.author(), jcd.title(), jcd.description()};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String hay = stringArray[i];
                    if (!this.contains(hay, needle, caseSensitive, wholeString)) continue;
                    return 6;
                }
            }
            for (Field field : clazz.getFields()) {
                JAMSVarDescription jvd = field.getAnnotation(JAMSVarDescription.class);
                if (jvd == null || !this.contains(jvd.description(), needle, caseSensitive, wholeString)) continue;
                return 6;
            }
        }
        return -1;
    }

    private boolean contains(String hay, String needle, boolean caseSensitive, boolean wholeString) {
        if (!caseSensitive) {
            hay = hay.toLowerCase();
            needle = needle.toLowerCase();
        }
        if (wholeString) {
            return hay.equals(needle);
        }
        return hay.indexOf(needle) != -1;
    }

    private void processClose() {
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (JUICE.getJuiceFrame().getCurrentView() == null) {
            this.repo.setSelected(true);
            this.model.setEnabled(false);
            this.modelSelect = false;
        } else {
            this.model.setEnabled(true);
        }
        if (this.modelSelect) {
            this.setTree(JUICE.getJuiceFrame().getCurrentView().getTree());
        } else {
            this.setTree(JUICE.getLibTree());
        }
        super.setVisible(b);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane pane = super.createRootPane();
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchDlg.this.processClose();
            }
        };
        InputMap inputMap = pane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        pane.getActionMap().put("ESCAPE", cancelAction);
        return pane;
    }
}

