/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.List;

@JAMSComponentDescription(title="GlacierReducer", author="Sven Kralisch", description="Convert glacier entities to non-glacier entities, controlled by given areal change", date="2020-09-02", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class GlacierReducer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="List of glacier entities")
    public Attribute.EntityCollection glacierEntities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Initial glacier area", unit="m\u00b2")
    public Attribute.Double initialGlacierArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Glacier area change", unit="%")
    public Attribute.Double glacierAreaChange;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Area attribute in glacier entities")
    public Attribute.String areaAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity's landuse attribute name", defaultValue="landuseID")
    public Attribute.String landuseAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="New land use ID of changed, non-glacier entities")
    public Attribute.Double newLanduseID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Glacier area after reduction")
    public Attribute.Double currentGlacierArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="List of entities that changed from glacier to non-glacier")
    public Attribute.EntityCollection changedEntities;
    double oldArea = -1.0;

    public void run() {
        int i;
        double targetGlacierArea = this.initialGlacierArea.getValue() * (this.glacierAreaChange.getValue() / 100.0);
        this.oldArea = this.oldArea == -1.0 ? this.initialGlacierArea.getValue() : this.currentGlacierArea.getValue();
        this.getModel().getRuntime().println("Trying to reduce glacier area by " + (this.oldArea - targetGlacierArea) + " m\u00b2...");
        List list = this.glacierEntities.getEntities();
        double newArea = 0.0;
        for (i = list.size() - 1; i >= 0; --i) {
            Attribute.Entity e = (Attribute.Entity)list.get(i);
            double area = e.getDouble(this.areaAttribute.getValue());
            if (!((newArea += area) > targetGlacierArea)) continue;
            double delta1 = Math.abs(targetGlacierArea - newArea);
            double delta2 = Math.abs(targetGlacierArea - newArea + area);
            if (!(delta2 < delta1)) break;
            ++i;
            newArea -= area;
            break;
        }
        List changedList = this.changedEntities.getEntities();
        changedList.clear();
        for (int j = 0; j < i; ++j) {
            Attribute.Entity entity = (Attribute.Entity)list.remove(0);
            entity.setDouble(this.landuseAttribute.getValue(), this.newLanduseID.getValue());
            changedList.add(entity);
        }
        this.currentGlacierArea.setValue(newArea);
        this.getModel().getRuntime().println("Reduced glacier area by " + (this.oldArea - newArea) + " m\u00b2 (" + changedList.size() + "/" + (list.size() + changedList.size()) + " entities)!");
    }
}

