/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Point;
import java.util.ArrayList;

@JAMSComponentDescription(title="J2KRasterRouting", author="Christin Michel", description="")
public class ReachToRaster
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reservoir objects")
    public Attribute.EntityCollection reservoirs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD1 inflow")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD2 inflow")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG1 inflow")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 inflow")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RD1 outflow")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RD2 outflow")
    public Attribute.Double outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RG1 outflow")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar RG2 outflow")
    public Attribute.Double outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD1 storage")
    public Attribute.Double actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD2 storage")
    public Attribute.Double actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG1 storage")
    public Attribute.Double actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double reachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="")
    public Attribute.Entity fuellstand;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Downstream hru entity")
    public Attribute.Entity toPoly;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Downstream reach entity")
    public Attribute.Entity toReach;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar groundwater excess")
    public Attribute.Double inGWExcess;

    public double[][] HRU_to_Raster(double ID, ArrayList hrulist, double wert, double[][] fuellstand) {
        double hru = 0.0;
        double durchschnitt = 0.0;
        Point p = new Point();
        int laenge1 = hrulist.size();
        for (int j = 0; j < laenge1; ++j) {
            p = (Point)((ArrayList)hrulist.get(j)).get(0);
            if ((double)p.x != ID) continue;
            int laenge2 = ((ArrayList)hrulist.get(j)).size();
            durchschnitt = wert / (double)(laenge2 - 1);
            for (int i = 1; i < laenge2; ++i) {
                p = (Point)((ArrayList)hrulist.get(j)).get(i);
                fuellstand[p.x][p.y] = durchschnitt;
            }
        }
        return fuellstand;
    }

    public void init() {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double[][] actfliessrichtung = null;
        double[][] actdgm = null;
        double[][] acthruraster = null;
        double[][] actflgew = null;
        double[][] actflgew1 = null;
        double[][] acthangneigung = null;
        int rastersize = 25;
        int time = 3600;
        double ID = this.reachID.getValue();
        double[][] RD1raster = null;
        double[][] RD1reach = null;
        double[][] RD2raster = null;
        double[][] RD2reach = null;
        double[][] RG1raster = null;
        double[][] RG1reach = null;
        double[][] RG2raster = null;
        double[][] RG2reach = null;
        Point p = new Point();
        try {
            acthruraster = (double[][])this.information.getObject("hruraster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actfliessrichtung = (double[][])this.information.getObject("fliessrichtung");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actdgm = (double[][])this.information.getObject("dgm");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actflgew = (double[][])this.information.getObject("flgew");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            actflgew1 = (double[][])this.information.getObject("flgew1");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            acthangneigung = (double[][])this.information.getObject("hangneigung");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        int[][] actdgm_sort = new int[3][actdgm.length * actdgm[0].length];
        try {
            actdgm_sort = (int[][])this.information.getObject("dgm_sort");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        ArrayList actreachlist = new ArrayList();
        try {
            actreachlist = (ArrayList)this.information.getObject("reachlist");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Point[][] actrouting = new Point[actdgm.length][actdgm[0].length];
        try {
            actrouting = (Point[][])this.information.getObject("routing");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD1reach = (double[][])this.fuellstand.getObject("RD1_reach");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD2reach = (double[][])this.fuellstand.getObject("RD2_reach");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RG1reach = (double[][])this.fuellstand.getObject("RG1_reach");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RG2reach = (double[][])this.fuellstand.getObject("RG2_reach");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD1raster = (double[][])this.fuellstand.getObject("RD1_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD2raster = (double[][])this.fuellstand.getObject("RD2_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RG1raster = (double[][])this.fuellstand.getObject("RG1_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RG2raster = (double[][])this.fuellstand.getObject("RG2_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity toReservoir = null;
        try {
            toReservoir = (Attribute.Entity)entity.getObject("to_reservoir");
        }
        catch (Attribute.Entity.NoSuchAttributeException e) {
            toReservoir = null;
        }
        double RD1out = this.outRD1.getValue();
        double RD2out = this.outRD2.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        double RD1act = this.actRD1.getValue();
        double RD2act = this.actRD2.getValue();
        double RG1act = this.actRG1.getValue();
        double RG2act = this.actRG2.getValue();
        double RD1in = this.inRD1.getValue();
        double RD2in = this.inRD2.getValue();
        double RG1in = this.inRG1.getValue();
        double RG2in = this.inRG2.getValue();
        RD1act = RD1in + RD1act;
        RD2act = RD2in + RD2act;
        RG1act = RG1in + RG1act;
        RG2act = RG2in + RG2act;
        RD2in += this.inGWExcess.getValue();
        this.inGWExcess.setValue(0.0);
        this.outRD1.setValue(0.0);
        this.outRD2.setValue(0.0);
        this.outRG1.setValue(0.0);
        this.outRG2.setValue(0.0);
        for (int i = 0; i < actreachlist.size(); ++i) {
            p = (Point)((ArrayList)actreachlist.get(i)).get(0);
            if (ID != (double)p.x) continue;
            RD1reach[i][0] = p.x;
            RD1reach[i][1] = RD1act;
            RD2reach[i][0] = p.x;
            RD2reach[i][1] = RD2act;
            RG1reach[i][0] = p.x;
            RG1reach[i][1] = RG1act;
            RG2reach[i][0] = p.x;
            RG2reach[i][1] = RG2act;
        }
        RD1raster = this.HRU_to_Raster(ID, actreachlist, RD1act, RD1raster);
        RD2raster = this.HRU_to_Raster(ID, actreachlist, RD2act, RD2raster);
        RG1raster = this.HRU_to_Raster(ID, actreachlist, RG1act, RG1raster);
        RG2raster = this.HRU_to_Raster(ID, actreachlist, RG2act, RG2raster);
        this.fuellstand.setObject("RD1_raster", (Object)RD1raster);
        this.fuellstand.setObject("RD2_raster", (Object)RD2raster);
        this.fuellstand.setObject("RG1_raster", (Object)RG1raster);
        this.fuellstand.setObject("RG2_raster", (Object)RG2raster);
    }
}

