/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Reach2AttributeTransfer", author="Sven Kralisch modified Manfred Fink", description="Simulation of artificial transfer of water and substances ", date="2014-11-14", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Reach2attributeTransfer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Provisioning attributes of the source reach")
    public Attribute.Double[] sourceValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Fraction of overall volume to be transferred", defaultValue="1")
    public Attribute.Double fraction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Lower boundary for transferred volume", defaultValue="-1")
    public Attribute.Double lowerBound;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Upper boundary for transferred volume", defaultValue="-1")
    public Attribute.Double upperBound;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Component volumes that were transferred")
    public Attribute.Double[] volumes;

    public void run() {
        double sum = 0.0;
        for (Attribute.Double sourceValue : this.sourceValues) {
            sum += sourceValue.getValue();
        }
        if (sum == 0.0) {
            return;
        }
        double targetVolume = sum * this.fraction.getValue();
        if (this.lowerBound.getValue() >= 0.0) {
            targetVolume = Math.max(targetVolume, Math.min(sum, this.lowerBound.getValue()));
        }
        if (this.upperBound.getValue() >= 0.0) {
            targetVolume = Math.min(targetVolume, this.upperBound.getValue());
        }
        double fractionSum = targetVolume / sum;
        for (int i = 0; i < this.sourceValues.length; ++i) {
            double x = this.sourceValues[i].getValue() * fractionSum;
            this.sourceValues[i].setValue(this.sourceValues[i].getValue() - x);
            this.volumes[i].setValue(x);
        }
    }
}

