/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessRouting", author="Peter Krause", description="Passes the output of the entities as input to the respective reach or unit")
public class J2KProcessHorizonRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD1 inflow")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD2 inflow")
    public Attribute.DoubleArray inRD2_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar groundwater excess", defaultValue="0")
    public Attribute.Double inGWExcess;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG1 inflow")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG2 inflow")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD1 outflow")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RD2 outflow")
    public Attribute.DoubleArray outRD2_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG1 outflow")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU statevar RG2 outflow")
    public Attribute.Double outRG2;
    double[][] fracOut;
    double[] percOut;

    public void init() {
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity toPoly = (Attribute.Entity)entity.getObject("to_poly");
        Attribute.Entity toReach = (Attribute.Entity)entity.getObject("to_reach");
        double RD1out = this.outRD1.getValue();
        double[] RD2out = this.outRD2_h.getValue();
        double RG1out = this.outRG1.getValue();
        double RG2out = this.outRG2.getValue();
        double RD2inReach = 0.0;
        if (!toPoly.isEmpty()) {
            int id = (int)((Attribute.Double)entity.getObject("ID")).getValue();
            double[] srcDepth = ((Attribute.DoubleArray)entity.getObject("depth_h")).getValue();
            double[] recDepth = ((Attribute.DoubleArray)toPoly.getObject("depth_h")).getValue();
            int srcHors = srcDepth.length;
            int recHors = recDepth.length;
            double[] RD2in = new double[recHors];
            this.calcParts(srcDepth, recDepth);
            double[] rdAr = ((Attribute.DoubleArray)toPoly.getObject("inRD2_h")).getValue();
            double RG1in = toPoly.getDouble("inRG1");
            for (int j = 0; j < recHors; ++j) {
                RD2in[j] = rdAr[j];
                for (int i = 0; i < srcHors; ++i) {
                    RD2in[j] = RD2in[j] + RD2out[i] * this.fracOut[i][j];
                    RG1in += RD2out[i] * this.percOut[i];
                }
            }
            for (int i = 0; i < srcHors; ++i) {
                RD2out[i] = 0.0;
            }
            if (recHors == 0) {
                System.out.println("RecHors is null at entity " + entity.getObject("ID"));
            }
            int n = recHors - 1;
            RD2in[n] = RD2in[n] + this.inGWExcess.getValue();
            double RD1in = toPoly.getDouble("inRD1");
            double RG2in = toPoly.getDouble("inRG2");
            RD1in += RD1out;
            RG1in += RG1out;
            RG2in += RG2out;
            RD1out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(0.0);
            this.outRD2_h.setValue(RD2out);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.inGWExcess.setValue(0.0);
            Attribute.DoubleArray rdA = (Attribute.DoubleArray)toPoly.getObject("inRD2_h");
            rdA.setValue(RD2in);
            toPoly.setDouble("inRD1", RD1in);
            toPoly.setObject("inRD2_h", (Object)rdA);
            toPoly.setDouble("inRG1", RG1in);
            toPoly.setDouble("inRG2", RG2in);
        } else if (!toReach.isEmpty()) {
            double RD1in = toReach.getDouble("inRD1");
            RD2inReach = toReach.getDouble("inRD2");
            for (int h = 0; h < RD2out.length; ++h) {
                RD2inReach += RD2out[h];
                RD2out[h] = 0.0;
            }
            RD2inReach += this.inGWExcess.getValue();
            double RG1in = toReach.getDouble("inRG1");
            double RG2in = toReach.getDouble("inRG2");
            RD1in += RD1out;
            RG1in += RG1out;
            RG2in += RG2out;
            RD1out = 0.0;
            RG1out = 0.0;
            RG2out = 0.0;
            this.outRD1.setValue(RD1out);
            toReach.setDouble("inRD1", RD1in);
            this.outRD2_h.setValue(RD2out);
            toReach.setDouble("inRD2", RD2inReach);
            this.outRG1.setValue(RG1out);
            toReach.setDouble("inRG1", RG1in);
            this.outRG2.setValue(RG2out);
            toReach.setDouble("inRG2", RG2in);
            this.inGWExcess.setValue(0.0);
        } else {
            this.getModel().getRuntime().println("Current entity ID: " + entity.getDouble("ID") + " has no receiver.");
        }
    }

    public void cleanup() {
    }

    private void calcParts(double[] depthSrc, double[] depthRec) {
        int i;
        int srcHorizons = depthSrc.length;
        int recHorizons = depthRec.length;
        double[] upBoundSrc = new double[srcHorizons];
        double[] lowBoundSrc = new double[srcHorizons];
        double low = 0.0;
        double up = 0.0;
        for (int i2 = 0; i2 < srcHorizons; ++i2) {
            upBoundSrc[i2] = up = (low += depthSrc[i2]) - depthSrc[i2];
            lowBoundSrc[i2] = low;
        }
        double[] upBoundRec = new double[recHorizons];
        double[] lowBoundRec = new double[recHorizons];
        low = 0.0;
        up = 0.0;
        for (i = 0; i < recHorizons; ++i) {
            upBoundRec[i] = up = (low += depthRec[i]) - depthRec[i];
            lowBoundRec[i] = low;
        }
        this.fracOut = new double[depthSrc.length][depthRec.length];
        this.percOut = new double[depthSrc.length];
        for (i = 0; i < depthSrc.length; ++i) {
            double sumFrac = 0.0;
            for (int j = 0; j < depthRec.length; ++j) {
                if (!(lowBoundSrc[i] > upBoundRec[j]) || !(upBoundSrc[i] < lowBoundRec[j])) continue;
                double relDepth = Math.min(lowBoundSrc[i], lowBoundRec[j]) - Math.max(upBoundSrc[i], upBoundRec[j]);
                double fracDepth = relDepth / depthSrc[i];
                sumFrac += fracDepth;
                this.fracOut[i][j] = fracDepth;
            }
            this.percOut[i] = 1.0 - sumFrac;
        }
    }
}

