/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="TemperatureLapseRate", author="Santosh Nepal, Peter Krause", description="Regionalisation of Temp through general adiabatic ratedepends upon given adaiabatic rate +++ included seasonal lapse rate")
public class TemperatureLapseRate1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="station elevation")
    public Attribute.DoubleArray statElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity elevation")
    public Attribute.Double entityElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the measured input from a base station")
    public Attribute.DoubleArray inputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculated output for the modelling entity")
    public Attribute.Double outputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lapse rate per 100 m elevation difference")
    public Attribute.Double lapseRateSummer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lapse rate per 100 m elevation difference")
    public Attribute.Double lapseRateWinter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current model time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="position array to determine best weights")
    public Attribute.IntegerArray statOrder;

    public void run() {
        int closestStation = this.statOrder.getValue()[0];
        double elevationdiff = this.statElev.getValue()[closestStation] - this.entityElev.getValue();
        int nowmonth = this.time.get(2);
        if (nowmonth >= 5 && nowmonth <= 8) {
            this.outputValue.setValue(elevationdiff * (this.lapseRateSummer.getValue() / 100.0) + this.inputValue.getValue()[closestStation]);
        } else {
            this.outputValue.setValue(elevationdiff * (this.lapseRateWinter.getValue() / 100.0) + this.inputValue.getValue()[closestStation]);
        }
    }
}

