/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="CalcNidwWeights", author="Peter Krause", description="Calculates weights for the regionalisation procedure")
public class CalcNidwWeights
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity x-coordinate")
    public Attribute.Double entityX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity y-coordinate")
    public Attribute.Double entityY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's x coordinates")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of station's y coordinates")
    public Attribute.DoubleArray statY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of IDW stations")
    public Attribute.Integer nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Power of IDW function")
    public Attribute.Double pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="weights for IDW part of regionalisation")
    public Attribute.DoubleArray statWeights;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Doug Boyle's famous function")
    public Attribute.Boolean equalWeights;
    IDW idw = new IDW();

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double[] w = this.statWeights.getValue();
        int n = this.statX.getValue().length;
        if (w == null || w.length != n) {
            w = new double[n];
        }
        if (this.equalWeights == null || !this.equalWeights.getValue()) {
            this.idw.init(this.statX.getValue(), this.statY.getValue(), null, (int)this.pidw.getValue(), IDW.Projection.ANY);
            this.idw.getIDW(this.entityX.getValue(), this.entityY.getValue(), null, this.nidw.getValue());
            System.arraycopy(this.idw.getWeights(), 0, w, 0, n);
        } else if (this.equalWeights.getValue()) {
            for (int i = 0; i < n; ++i) {
                w[i] = 1.0 / (double)n;
            }
        }
        this.statWeights.setValue(w);
    }

    public void cleanup() throws Attribute.Entity.NoSuchAttributeException {
        int nstat = this.statWeights.getValue().length;
        for (int i = 0; i < nstat; ++i) {
            this.statWeights.getValue()[i] = 0.0;
        }
    }
}

