/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.refET;

public class CalcVariables {
    public static double calcAirPressure(double elevation) {
        double R = 287.0;
        double P0 = 103.1;
        double LR = 0.0065;
        double TK0 = 293.16;
        double G = 9.807;
        double airPressure = 103.1 * Math.pow((293.16 - 0.0065 * elevation) / 293.16, 5.25703564727955);
        return airPressure;
    }

    public static double calcAtmosphericDensity(double temperature, double airPressure) {
        double C = 1.01;
        double R = 287.0;
        double absTemp = 1.01 * (temperature + 273.16);
        double atmDens = 1000.0 * airPressure / (287.0 * absTemp);
        return atmDens;
    }

    public static double calcSaturationVapourPressure(double maxTemp, double minTemp) {
        double esTmax = 0.6108 * Math.exp(17.27 * maxTemp / (237.3 + maxTemp));
        double esTmin = 0.6108 * Math.exp(17.27 * minTemp / (237.3 + minTemp));
        double esT = 0.5 * (esTmax + esTmin);
        return esT;
    }

    public static double calcSaturationVapourPressure(double temperature) {
        double esT = 0.6108 * Math.exp(17.27 * temperature / (237.3 + temperature));
        return esT;
    }

    public static double calcActualVapourPressure(double maxEst, double minEst, double maxRhum, double minRhum) {
        double ea = 0.5 * (minEst * (maxRhum / 100.0) + maxEst * (maxRhum / 100.0));
        return ea;
    }

    public static double calcActualVapourPressure(double esT, double rhum) {
        double ea = esT * (rhum / 100.0);
        return ea;
    }

    public static double calc_slopeOfSaturationPressureCurve(double temperature) {
        double sospc = 4098.0 * (0.6108 * Math.exp(17.27 * temperature / (temperature + 237.3))) / Math.pow(temperature + 237.3, 2.0);
        return sospc;
    }

    public static double calc_latentHeatOfVaporization(double temperature) {
        double L = (2501.0 - 2.361 * temperature) / 1000.0;
        return L;
    }

    public static double calc_psyConst(double airPressure, double latHeat) {
        double CP = 0.001013;
        double VM = 0.622;
        double psyConst = CP * airPressure / (VM * latHeat);
        return psyConst;
    }

    public static double calcAerodynamicResistance(double windSpeed) {
        if (windSpeed < 0.5) {
            windSpeed = 0.5;
        }
        double ra = 208.0 / windSpeed;
        return ra;
    }

    public static double calcNetRadiation(double maxTemp, double minTemp, double solRad, double extRad, double actVP, double albedo, double clearSkyTrans, String tempRes) {
        double Sday = 4.9032E-9;
        double Shour = 2.043E-10;
        double fh = 0.34 - 0.14 * Math.sqrt(actVP);
        double ghc = extRad * clearSkyTrans;
        double fc = 1.35 * (solRad / ghc) - 0.35;
        double swNetRad = (1.0 - albedo) * solRad;
        double S = 0.0;
        if (tempRes.equals("d")) {
            S = 4.9032E-9;
        } else if (tempRes.equals("h")) {
            S = 2.043E-10;
        }
        double lwNetRad = S * fc * fh * (0.5 * (Math.pow(maxTemp + 273.15, 4.0) + Math.pow(minTemp + 273.15, 4.0)));
        double netRad = swNetRad - lwNetRad;
        return netRad;
    }
}

