/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.workspace.stores.InputDataStore;
import java.util.ArrayList;

@JAMSComponentDescription(title="StationEntityCreator", author="Peter Krause", description="This component creates a set of entities which equals climate orprecipitation stations used as input.", date="2010-05-10", version="1.0")
public class StationEntityCreator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of entities")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Input climates station data file")
    public Attribute.String inFile;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of the datastore to read station coordinates from")
    public Attribute.String dataStoreID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the station names")
    public Attribute.StringArray statNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the station Ids")
    public Attribute.IntegerArray statId;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the station elevation")
    public Attribute.DoubleArray statElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the station x-coordinates")
    public Attribute.DoubleArray statX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the station y-coordinates")
    public Attribute.DoubleArray statY;
    ArrayList<Attribute.Entity> entityList = new ArrayList();

    public void init() {
        InputDataStore store = null;
        if (this.dataStoreID != null) {
            store = this.getModel().getWorkspace().getInputDataStore(this.dataStoreID.getValue());
        }
        this.statNames.setValue(this.listToStringArray(store.getDataSetDefinition().getAttributeValues("NAME")));
        this.statId.setValue(this.listToIntegerArray(store.getDataSetDefinition().getAttributeValues("ID")));
        this.statElev.setValue(this.listToDoubleArray(store.getDataSetDefinition().getAttributeValues("ELEVATION")));
        this.statX.setValue(this.listToDoubleArray(store.getDataSetDefinition().getAttributeValues("X")));
        this.statY.setValue(this.listToDoubleArray(store.getDataSetDefinition().getAttributeValues("Y")));
        int nEntities = this.statNames.getValue().length;
        Attribute.EntityCollection ents = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        for (int i = 0; i < nEntities; ++i) {
            try {
                Attribute.Entity e = (Attribute.Entity)this.getModel().getRuntime().getDataFactory().createInstance(Attribute.Entity.class);
                e.setObject("NAME", (Object)this.statNames.getValue()[i]);
                e.setInt("ID", this.statId.getValue()[i]);
                e.setDouble("ELEVATION", this.statElev.getValue()[i]);
                e.setDouble("X", this.statX.getValue()[i]);
                e.setDouble("Y", this.statY.getValue()[i]);
                this.entityList.add(e);
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.entities.setEntities(this.entityList);
    }

    private double[] listToDoubleArray(ArrayList<Object> list) {
        double[] result = new double[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = (Double)o;
            ++i;
        }
        return result;
    }

    private int[] listToIntegerArray(ArrayList<Object> list) {
        int[] result = new int[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = Integer.parseInt(o.toString());
            ++i;
        }
        return result;
    }

    private String[] listToStringArray(ArrayList<Object> list) {
        String[] result = new String[list.size()];
        int i = 0;
        for (Object o : list) {
            result[i] = o.toString();
            ++i;
        }
        return result;
    }
}

