/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.unijena.j2k.J2KFunctions;

public class StandardEntityReaderRR
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;

    public void init() {
        this.hrus.setEntities(J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue()), this.getModel()));
        for (Attribute.Entity e : this.hrus.getEntityArray()) {
            try {
                e.setId((long)e.getDouble("ID"));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRU parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        this.reaches.setEntities(J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue()), this.getModel()));
        this.createTopology();
        this.getModel().getRuntime().println("Create ordered hru-list", 2);
        this.createOrderedList(this.hrus, "to_poly");
        this.getModel().getRuntime().println("Create ordered reach-list", 2);
        this.createOrderedList(this.reaches, "to_reach");
        this.getModel().getRuntime().println("Entities read successfull!", 2);
        Attribute.Entity[] Reaches = this.reaches.getEntityArray();
        int laenge = Reaches.length;
        for (int i = 0; i < laenge / 2; ++i) {
            Attribute.Entity change = Reaches[i];
            Reaches[i] = Reaches[laenge - 1 - i];
            Reaches[laenge - 1 - i] = change;
        }
        ArrayList<Attribute.Entity> list = new ArrayList<Attribute.Entity>();
        for (int i = 0; i < laenge; ++i) {
            list.add(Reaches[i]);
        }
        this.reaches.setEntities(list);
    }

    protected boolean cycleCheck(Attribute.Entity node, Stack<Attribute.Entity> searchStack, HashSet<Attribute.Double> closedList, HashSet<Attribute.Double> visitedList) {
        if (searchStack.indexOf(node) != -1) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((Attribute.Entity)searchStack.get(i)).getDouble("ID") + " ";
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        if (closedList.contains(node.getObject("ID"))) {
            return false;
        }
        visitedList.add((Attribute.Double)node.getObject("ID"));
        Attribute.Entity child_node = (Attribute.Entity)node.getObject("to_poly");
        if (child_node.isEmpty()) {
            child_node = null;
        }
        if (child_node != null) {
            searchStack.push(node);
            boolean result = this.cycleCheck(child_node, searchStack, closedList, visitedList);
            searchStack.pop();
            return result;
        }
        return false;
    }

    protected boolean cycleCheck() {
        HashSet<Attribute.Double> closedList = new HashSet<Attribute.Double>();
        HashSet<Attribute.Double> visitedList = new HashSet<Attribute.Double>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator hruIterator = this.hrus.getEntities().iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            Attribute.Entity start_node = (Attribute.Entity)hruIterator.next();
            if (closedList.contains(start_node.getObject("ID"))) continue;
            if (this.cycleCheck(start_node, new Stack<Attribute.Entity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    protected void createTopology() {
        HashMap<Double, Attribute.Entity> hruMap = new HashMap<Double, Attribute.Entity>();
        HashMap<Double, Attribute.Entity> reachMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity e : this.hrus.getEntities()) {
            hruMap.put(e.getDouble("ID"), e);
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            reachMap.put(e.getDouble("ID"), e);
        }
        Attribute.Entity nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        hruMap.put(new Double(0.0), nullEntity);
        reachMap.put(new Double(0.0), nullEntity);
        for (Attribute.Entity e : this.hrus.getEntities()) {
            e.setObject("to_poly", hruMap.get(e.getDouble("to_poly")));
            e.setObject("to_reach", reachMap.get(e.getDouble("to_reach")));
        }
        for (Attribute.Entity e : this.reaches.getEntities()) {
            e.setObject("to_reach", reachMap.get(e.getDouble("to-reach")));
        }
        if (this.getModel().getRuntime().getDebugLevel() >= 3) {
            if (this.cycleCheck()) {
                this.getModel().getRuntime().println("HRUs --> cycle found ... :( ");
            } else {
                this.getModel().getRuntime().println("HRUs --> no cycle found");
            }
        }
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Object, Integer> depthMap = new HashMap<Object, Integer>();
        boolean mapChanged = true;
        Iterator hruIterator = col.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put(hruIterator.next(), new Integer(0));
        }
        int numHRUs = col.getEntities().size();
        int maxDepth = 0;
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                Attribute.Entity f = (Attribute.Entity)e.getObject(asso);
                if (f.isEmpty()) {
                    f = null;
                }
                if (f == null) continue;
                Integer eDepth = (Integer)depthMap.get(e);
                Integer fDepth = (Integer)depthMap.get(f);
                if (fDepth > eDepth) continue;
                depthMap.put(f, new Integer(eDepth + 1));
                mapChanged = true;
            }
        }
        maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }
}

